/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.util.DriverInfo;

public class BitValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return -7;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        if (elem.getSize() > 1) {
            return String.class;
        }
        return elem.canBeNull() ? Boolean.class : Boolean.TYPE;
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        if (elem.getSize() > 1) {
            DriverInfo d = DriverInfo.lookup(rs.getStatement().getConnection().getMetaData());
            if (d == DriverInfo.MySQL) {
                return rs.getBigDecimal(elem.getPosition()).toBigInteger().toString(2);
            }
            return rs.getString(elem.getPosition());
        }
        boolean value = rs.getBoolean(elem.getPosition());
        return !value && rs.wasNull() ? null : Boolean.valueOf(value);
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof byte[]) {
            ps.setBytes(pos, (byte[])value);
        } else if (value instanceof Boolean) {
            ps.setBoolean(pos, (Boolean)value);
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }

    @Override
    public String getParameterExpression(DatabaseMetaData metaData, Object value, ColumnInfo ci) {
        try {
            DriverInfo driver = DriverInfo.lookup(metaData);
            if (!(driver != DriverInfo.Postgres && driver != DriverInfo.MySQL || ci.getSqlType().toLowerCase().contains("bool"))) {
                return this.coerce(driver, value, ci);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return "?";
    }

    private String coerce(DriverInfo driver, Object value, ColumnInfo ci) throws SQLException {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Boolean) {
            return "B'" + ((Boolean)value != false ? (char)'1' : '0') + "'";
        }
        if (value instanceof CharSequence) {
            return "B'" + value + "'" + this.cast(driver, ci);
        }
        throw new SQLException("Unexpected type for BIT: " + value.getClass());
    }

    private String cast(DriverInfo driver, ColumnInfo ci) {
        if (driver != DriverInfo.Postgres) {
            return "";
        }
        Integer size = ci.getSize();
        if (size != null && size > 0) {
            return "::" + ci.getSqlType() + "(" + size + ")";
        }
        return "";
    }
}

