/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class DecimalValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 3;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        return rs.getBigDecimal(elem.getPosition());
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof BigDecimal) {
            ps.setBigDecimal(pos, (BigDecimal)value);
        } else if (value instanceof Number) {
            ps.setBigDecimal(pos, BigDecimal.valueOf(((Number)value).doubleValue()));
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

