/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.CustomEntityFactory;
import manifold.sql.rt.api.DbConfigProvider;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.api.DefaultCustomEntityFactory;
import manifold.sql.rt.api.DefaultTxScopeProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.TxScopeProvider;
import manifold.sql.rt.api.TypeProvider;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.sql.rt.impl.BasicCrudProvider;
import manifold.sql.rt.impl.BasicTxScopeProvider;
import manifold.sql.rt.impl.DbConfigFinder;
import manifold.sql.rt.impl.HikariConnectionProvider;
import manifold.sql.rt.impl.ResourceDbLocationProvider;
import manifold.sql.rt.impl.ThreadLocalDefaultTxScopeProvider;
import manifold.sql.rt.impl.accessors.DefaultTypeProvider;
import manifold.sql.rt.impl.accessors.DefaultValueAccessorProvider;

public class DefaultDependencies
implements Dependencies {
    private final Map<Class<?>, Object> _instances = new ConcurrentHashMap();

    @Override
    public DbConfigProvider getDbConfigProvider() {
        return this.getOrCreate(DbConfigFinder.class);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.getOrCreate(HikariConnectionProvider.class);
    }

    @Override
    public CrudProvider getCrudProvider() {
        return this.getOrCreate(BasicCrudProvider.class);
    }

    @Override
    public DbLocationProvider getDbLocationProvider() {
        return this.getOrCreate(ResourceDbLocationProvider.class);
    }

    @Override
    public DefaultTxScopeProvider getDefaultTxScopeProvider() {
        return this.getOrCreate(ThreadLocalDefaultTxScopeProvider.class);
    }

    @Override
    public TxScopeProvider getTxScopeProvider() {
        return this.getOrCreate(BasicTxScopeProvider.class);
    }

    @Override
    public TypeProvider getTypeProvider() {
        return new DefaultTypeProvider();
    }

    @Override
    public ValueAccessorProvider getValueAccessorProvider() {
        return this.getOrCreate(DefaultValueAccessorProvider.class);
    }

    @Override
    public CustomEntityFactory getCustomEntityFactory() {
        return new DefaultCustomEntityFactory();
    }

    @Override
    public <T> T getOrCreate(Class<T> cls) {
        return (T)this._instances.computeIfAbsent(cls, __ -> {
            try {
                return cls.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

