/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUtil.class);

    public static String enquoteIdentifier(String id, DatabaseMetaData metaData) throws SQLException {
        String quoteStr = metaData.getIdentifierQuoteString();
        if (quoteStr.equals(" ")) {
            return id;
        }
        if (quoteStr.length() == 1) {
            return quoteStr + id + quoteStr;
        }
        if (quoteStr.length() == 2) {
            return quoteStr.charAt(0) + id + quoteStr.charAt(1);
        }
        throw new SQLException("Unexpected identifier quote string: " + quoteStr);
    }

    public static String handleAnonQueryColumn(String name, int oneBasedIndex) {
        if (name == null || name.isEmpty()) {
            name = "col_" + oneBasedIndex;
        }
        return name;
    }
}

