/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.sql.rt.api.Entity;
import manifold.sql.rt.api.KeyRef;
import manifold.sql.rt.api.OperableTxBindings;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.TxKind;
import manifold.sql.rt.api.TxScope;
import manifold.util.concurrent.LockingLazyVar;

public class BasicTxBindings
implements OperableTxBindings {
    private final Bindings _persistedState;
    private final Map<String, Object> _changes;
    private final Map<String, Object> _onHold;
    private final LockingLazyVar<Bindings> _metadata;
    private Entity _owner;
    private final OperableTxScope _txScope;
    private TxKind _txKind;
    private boolean _delete;

    public BasicTxBindings(TxScope txScope, TxKind txKind, Bindings initialState) {
        if (initialState == null) {
            throw new NullPointerException("initialState is null");
        }
        this._txScope = (OperableTxScope)txScope;
        this._txKind = txKind;
        this._changes = new LinkedHashMap<String, Object>();
        switch (this._txKind) {
            case Insert: {
                this._persistedState = new DataBindings();
                this._changes.putAll((Map<String, Object>)initialState);
                break;
            }
            case Update: {
                this._persistedState = initialState;
                break;
            }
            default: {
                throw new IllegalArgumentException("TxKind '" + (Object)((Object)txKind) + "' not supported here");
            }
        }
        this._onHold = new LinkedHashMap<String, Object>();
        this._metadata = LockingLazyVar.make(() -> new DataBindings());
    }

    @Override
    public Entity getOwner() {
        return this._owner;
    }

    @Override
    public void setOwner(Entity owner) {
        this._owner = owner;
    }

    @Override
    public TxScope getTxScope() {
        return this._txScope;
    }

    @Override
    public boolean isForInsert() {
        return this._txKind == TxKind.Insert && !this._delete;
    }

    @Override
    public boolean isForUpdate() {
        return (this._txKind == TxKind.Update || this._txKind == TxKind.InsertUpdate) && !this._delete;
    }

    @Override
    public boolean isForDelete() {
        return this._delete;
    }

    @Override
    public void setDelete(boolean value) {
        if (this._delete == value) {
            return;
        }
        this._delete = value;
        switch (this._txKind) {
            case Update: 
            case InsertUpdate: {
                if (this._delete) {
                    this._txScope.addRow(this.getOwner());
                    break;
                }
                if (!this._changes.isEmpty()) break;
                this._txScope.removeRow(this.getOwner());
                break;
            }
            case Insert: {
                if (this._delete) {
                    this._txScope.removeRow(this.getOwner());
                    break;
                }
                this._txScope.addRow(this.getOwner());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can't delete, TxKind is " + (Object)((Object)this._txKind));
            }
        }
    }

    @Override
    public void holdValues(Bindings valuesToHold) {
        this._onHold.putAll((Map<String, Object>)valuesToHold);
    }

    @Override
    public void holdValue(String name, Object value) {
        this._onHold.put(name, value);
    }

    @Override
    public Object getHeldValue(String name) {
        return this._onHold.get(name);
    }

    @Override
    public void dropHeldValues() {
        this._onHold.clear();
    }

    @Override
    public void commit() throws SQLException {
        if (this._txKind == TxKind.Unknown) {
            throw new SQLException("Cannot commit bindings in 'Unknown' state. Bindings were likely deleted or rolled back from creation.");
        }
        if (this._delete) {
            this._persistedState.clear();
            this._changes.clear();
            this._onHold.clear();
            this._txKind = TxKind.Unknown;
            return;
        }
        this._persistedState.putAll(this._changes);
        this._changes.clear();
        this._persistedState.putAll(this._onHold);
        this._onHold.clear();
        this._txKind = TxKind.Update;
    }

    @Override
    public void failedCommit() throws SQLException {
        if (this._txKind == TxKind.InsertUpdate) {
            this._txKind = TxKind.Insert;
        }
        this.dropHeldValues();
    }

    @Override
    public void reuse() {
        if (this._txKind == TxKind.Insert) {
            this._txKind = TxKind.InsertUpdate;
        }
    }

    @Override
    public void revert() throws SQLException {
        switch (this._txKind) {
            case Insert: {
                this._changes.clear();
                this._txKind = TxKind.Unknown;
                break;
            }
            case Update: {
                this._changes.clear();
                this._delete = false;
                break;
            }
            default: {
                throw new SQLException("Cannot rollback bindings in 'Unknown' state.");
            }
        }
    }

    public Bindings getMetadata() {
        return (Bindings)this._metadata.get();
    }

    public Object put(String name, Object value) {
        Object existing;
        if (value instanceof IBindingsBacked) {
            throw new IllegalArgumentException("Non-raw bindings: " + value);
        }
        if (this.isForDelete()) {
            throw new RuntimeException("Illegal operation, instance pending deletion");
        }
        if (this._txKind == TxKind.Unknown) {
            throw new RuntimeException("Cannot modify bindings in 'Unknown' state. Bindings were likely deleted or rolled back from creation.");
        }
        this.checkKey(name);
        if (this._persistedState.containsKey((Object)name) && Objects.equals(existing = this._persistedState.get((Object)name), value)) {
            this._changes.remove(name);
            if (this._changes.isEmpty()) {
                this._txScope.removeRow(this.getOwner());
            }
            return existing;
        }
        this._txScope.addRow(this.getOwner());
        return this._changes.put(name, value);
    }

    public void putAll(Map<? extends String, ?> toMerge) {
        if (toMerge == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
            String key = entry.getKey();
            this.checkKey(key);
            this.put(key, entry.getValue());
        }
    }

    public void clear() {
        this._changes.clear();
    }

    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this._changes.containsKey(key) || this._persistedState.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._changes.containsValue(value) || this._persistedState.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>(this._changes.entrySet());
        this._persistedState.entrySet().stream().filter(e -> !this._changes.containsKey(e.getKey())).forEach(e -> entrySet.add((Map.Entry<String, Object>)e));
        return entrySet;
    }

    @Override
    public Map<String, Object> uncommittedChangesEntrySet() {
        return new LinkedHashMap<String, Object>(this._changes);
    }

    @Override
    public Map<String, Object> persistedStateEntrySet() {
        return new LinkedHashMap<String, Object>((Map<String, Object>)this._persistedState);
    }

    @Override
    public Object getPersistedStateValue(String name) {
        return this._persistedState.get((Object)name);
    }

    public Object get(Object key) {
        this.checkKey(key);
        if (this._changes.containsKey((String)key)) {
            Object value = this._changes.get(key);
            if (value instanceof KeyRef && ((Entity)(value = ((KeyRef)value).getRef())).getBindings().isForDelete()) {
                value = null;
            }
            return value;
        }
        return this._persistedState.get(key);
    }

    public boolean isEmpty() {
        return this._changes.isEmpty() && this._persistedState.isEmpty();
    }

    public Set<String> keySet() {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>(this._persistedState.keySet());
        keySet.addAll(this._changes.keySet());
        return keySet;
    }

    public Object remove(Object key) {
        this.checkKey(key);
        Object priorValue = this._changes.containsKey((String)key) ? this._changes.get(key) : this._persistedState.get(key);
        this._changes.put((String)key, null);
        return priorValue;
    }

    public int size() {
        return this.keySet().size();
    }

    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this._changes.values());
        this._persistedState.entrySet().stream().filter(e -> !this._changes.containsKey(e.getKey())).forEach(e -> values.add(e.getValue()));
        return values;
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key should be a String");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicTxBindings)) {
            return false;
        }
        BasicTxBindings that = (BasicTxBindings)o;
        return this.entrySet().equals(that.entrySet());
    }

    public int hashCode() {
        return Objects.hash(this.entrySet());
    }
}

