/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.function.BiPredicate;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.rt.util.SqlScriptParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlScriptRunner.class);

    public static void runScript(Connection connection, String script) throws SQLException {
        SqlScriptRunner.runScript(connection, script, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Connection connection, String script, BiPredicate<String, SQLException> exceptionHandler) throws SQLException {
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            Statement stmt = connection.createStatement();
            List<String> commands = SqlScriptParser.getCommands(script, SqlScriptRunner.extraSeparator(connection));
            for (String command : commands) {
                if (exceptionHandler == null) {
                    stmt.addBatch(command);
                    continue;
                }
                try {
                    stmt.execute(command);
                }
                catch (SQLException e) {
                    if (exceptionHandler.test(command, e)) continue;
                    throw e;
                }
            }
            if (exceptionHandler == null) {
                stmt.executeBatch();
            }
            connection.commit();
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    private static SqlScriptParser.ExtraSeparator extraSeparator(Connection c) throws SQLException {
        DriverInfo driver = DriverInfo.lookup(c.getMetaData());
        if (driver == DriverInfo.SqlServer) {
            return SqlScriptParser.ExtraSeparator.Go;
        }
        if (driver == DriverInfo.Oracle) {
            return SqlScriptParser.ExtraSeparator.Slash;
        }
        return null;
    }
}

