/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.util.ArrayList;
import java.util.List;

public class SqlScriptParser {
    private static final int EOF = -2;
    private final String _script;
    private final List<String> _commands;
    private final ExtraSeparator _extraSeparator;
    private int _pos = -1;

    public static List<String> getCommands(String script) {
        return SqlScriptParser.getCommands(script, null);
    }

    public static List<String> getCommands(String script, ExtraSeparator extraSeparator) {
        return new SqlScriptParser(script, extraSeparator).parse();
    }

    private SqlScriptParser(String script, ExtraSeparator extraSeparator) {
        this._script = script;
        this._extraSeparator = extraSeparator;
        this._commands = new ArrayList<String>();
    }

    private boolean goSeparator() {
        return this._extraSeparator == ExtraSeparator.Go;
    }

    private boolean slashSeparator() {
        return this._extraSeparator == ExtraSeparator.Slash;
    }

    private List<String> parse() {
        this.next();
        while (!this.isEof()) {
            this.parseCommand();
        }
        return this._commands;
    }

    private void parseCommand() {
        int pos = this._pos;
        int blockDepth = 0;
        int endCommandPos = -1;
        boolean hasWords = false;
        while (!this.isEof()) {
            while (this.eatComments() || this.eatWhitespace()) {
            }
            if ((this.match(';') || this.slashSeparator() && this.match('/')) && blockDepth == 0) {
                endCommandPos = this._pos - 1;
                break;
            }
            String word = this.matchWord();
            if (this.goSeparator() && word.equalsIgnoreCase("GO")) {
                if (blockDepth == 0) {
                    endCommandPos = this._pos - 2;
                    break;
                }
            } else if (this.is$$Quote(word)) {
                this.eatUntil(word);
            } else if (word.equalsIgnoreCase("BEGIN")) {
                ++blockDepth;
            } else if (word.equalsIgnoreCase("CASE")) {
                ++blockDepth;
            } else if (word.equalsIgnoreCase("END")) {
                boolean isReallyEND = true;
                if (!this.isEof() && this.ch() == ' ') {
                    this.next();
                    String endWhat = this.matchWord();
                    if (endWhat.equalsIgnoreCase("IF") || endWhat.equalsIgnoreCase("LOOP")) {
                        isReallyEND = false;
                    }
                }
                if (isReallyEND && --blockDepth < 0) {
                    throw new IllegalStateException("Unbalanced BEGIN/CASE END (see [*])\n\n" + new StringBuilder(this._script).insert(this._pos - 3, " [*]").toString());
                }
            } else if (word.equalsIgnoreCase("SEPARATOR")) {
                while (this.eatComments() || this.eatWhitespace()) {
                }
                this.matchStringLiteral();
            } else {
                hasWords = hasWords || !word.isEmpty();
            }
            this.matchNonWord();
        }
        if (hasWords) {
            String command = this._script.substring(pos, this.isEof() ? this._script.length() : (endCommandPos > 0 ? endCommandPos : this._pos));
            if (!(command = command.trim()).isEmpty()) {
                this._commands.add(command);
            }
        }
    }

    private boolean is$$Quote(String word) {
        return word.length() > 1 && word.startsWith("$") && word.endsWith("$");
    }

    private boolean eatWhitespace() {
        boolean found = false;
        while (!this.isEof() && Character.isWhitespace(this.ch())) {
            found = true;
            this.next();
        }
        return found;
    }

    private boolean eatComments() {
        return this.eatLineComment() || this.eatMultiLineComment();
    }

    private boolean eatMultiLineComment() {
        return this.eatBetweenTokens("/*", "*/");
    }

    private boolean eatBetweenTokens(String open, String close) {
        boolean comment = false;
        while (!this.isEof()) {
            if (comment) {
                if (this.match(close)) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match(open)) break;
            comment = true;
        }
        return false;
    }

    private boolean eatUntil(String close) {
        boolean comment = false;
        while (!this.isEof()) {
            if (this.match(close)) {
                return true;
            }
            this.next();
        }
        return false;
    }

    private boolean eatLineComment() {
        boolean comment = false;
        while (!this.isEof()) {
            if (comment) {
                if (this.match('\n')) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match("--")) break;
            comment = true;
        }
        return false;
    }

    private boolean isEof() {
        return this._pos == -2;
    }

    private void next() {
        if (this.isEof()) {
            return;
        }
        if (this._pos + 1 == this._script.length()) {
            this._pos = -2;
            return;
        }
        ++this._pos;
    }

    private char ch() {
        return this._script.charAt(this._pos);
    }

    private boolean match(char c) {
        if (this.isEof()) {
            return false;
        }
        if (this.ch() == c) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean match(String s) {
        return this.match(s, false);
    }

    private boolean match(String s, boolean peek) {
        if (this.isEof()) {
            return false;
        }
        if (this._script.regionMatches(true, this._pos, s, 0, s.length())) {
            if (!peek) {
                this._pos += s.length();
                if (this._pos == this._script.length()) {
                    this._pos = -2;
                }
            }
            return true;
        }
        return false;
    }

    private String matchWord() {
        return this.matchWord(false);
    }

    private String matchWord(boolean peek) {
        if (this.isEof()) {
            return "";
        }
        int savePos = this._pos;
        StringBuilder sb = new StringBuilder();
        if (Character.isJavaIdentifierStart(this.ch())) {
            sb.append(this.ch());
            this.next();
            while (!this.isEof() && Character.isJavaIdentifierPart(this.ch())) {
                sb.append(this.ch());
                this.next();
            }
        }
        if (peek) {
            this._pos = savePos;
        }
        return sb.toString();
    }

    private String matchStringLiteral() {
        if (this.isEof()) {
            return "";
        }
        if (this.match('\'')) {
            StringBuilder sb = new StringBuilder();
            while (!this.match('\'')) {
                sb.append(this.ch());
                this.next();
            }
            return sb.toString();
        }
        return null;
    }

    private String matchNonWord() {
        if (this.isEof()) {
            return "";
        }
        while (this.eatWhitespace() || this.eatComments()) {
        }
        StringBuilder sb = new StringBuilder();
        while (!(this.isEof() || this.ch() == ';' || this.slashSeparator() && this.ch() == '/' || Character.isJavaIdentifierStart(this.ch()) || this.match("--", true) || this.match("/*", true))) {
            sb.append(this.ch());
            this.next();
        }
        return sb.toString();
    }

    public static enum ExtraSeparator {
        Go,
        Slash;

    }
}

