/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Period;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.impl.accessors.OtherValueAccessor;
import manifold.util.ReflectUtil;

public class Oracle_IntervalYmValueAccessor
extends OtherValueAccessor {
    public static final int JDBC_TYPE_INTERVALYM = -103;
    private static final String JAVA_TYPE_INTERVALYM = "oracle.sql.INTERVALYM";
    private static final int SIZE_INTERVALYM = 5;
    private static final int HIGH_BIT = Integer.MIN_VALUE;

    @Override
    public int getJdbcType() {
        return -103;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return Period.class;
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Object value = super.getRowValue(rs, elem);
        if (value != null && value.getClass().getTypeName().equals(JAVA_TYPE_INTERVALYM)) {
            value = this.toPeriod(value);
        }
        return value;
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value instanceof Period) {
            value = this.toIntervalYm((Period)value);
        }
        super.setParameter(ps, pos, value);
    }

    private Period toPeriod(Object value) {
        byte[] bytes = (byte[])ReflectUtil.method((Object)value, (String)"toBytes", (Class[])new Class[0]).invoke(new Object[0]);
        int year = Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
        int month = Byte.toUnsignedInt(bytes[4]) - 60;
        return Period.of(year ^= Integer.MIN_VALUE, month, 0);
    }

    private Object toIntervalYm(Period period) {
        int year = period.getYears() ^ Integer.MIN_VALUE;
        byte[] bytes = new byte[5];
        bytes[0] = (byte)(year >> 24);
        bytes[1] = (byte)(year >> 16 & 0xFF);
        bytes[2] = (byte)(year >> 8 & 0xFF);
        bytes[3] = (byte)(year & 0xFF);
        int month = period.getMonths() + 60;
        bytes[4] = (byte)(month & 0xFF);
        return ReflectUtil.constructor((String)JAVA_TYPE_INTERVALYM, (Class[])new Class[]{byte[].class}).newInstance(new Object[]{bytes});
    }
}

