/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.impl.accessors.OtherValueAccessor;
import manifold.util.ReflectUtil;

public class Oracle_IntervalDsValueAccessor
extends OtherValueAccessor {
    public static final int JDBC_TYPE_INTERVALDS = -104;
    private static final String JAVA_TYPE_INTERVALDS = "oracle.sql.INTERVALDS";
    private static final int SIZE_INTERVALDS = 11;
    private static final int HIGH_BIT_FLAG = Integer.MIN_VALUE;

    @Override
    public int getJdbcType() {
        return -104;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return Duration.class;
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Object value = super.getRowValue(rs, elem);
        if (value != null && value.getClass().getTypeName().equals(JAVA_TYPE_INTERVALDS)) {
            value = this.toDuration(value);
        }
        return value;
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value instanceof Duration) {
            value = this.toIntervalDs((Duration)value);
        }
        super.setParameter(ps, pos, value);
    }

    private Duration toDuration(Object value) {
        byte[] bytes = (byte[])ReflectUtil.method((Object)value, (String)"toBytes", (Class[])new Class[0]).invoke(new Object[0]);
        int day = Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
        int hour = Byte.toUnsignedInt(bytes[4]) - 60;
        int minute = Byte.toUnsignedInt(bytes[5]) - 60;
        int second = Byte.toUnsignedInt(bytes[6]) - 60;
        int nano = Byte.toUnsignedInt(bytes[7]) << 24 | Byte.toUnsignedInt(bytes[8]) << 16 | Byte.toUnsignedInt(bytes[9]) << 8 | Byte.toUnsignedInt(bytes[10]);
        return Duration.ofDays(day ^= Integer.MIN_VALUE).plusHours(hour).plusMinutes(minute).plusSeconds(second).plusNanos(nano ^= Integer.MIN_VALUE);
    }

    private Object toIntervalDs(Duration duration) {
        long seconds = duration.getSeconds();
        if (duration.isNegative()) {
            ++seconds;
        }
        int day = Math.toIntExact(seconds / 24L / 60L / 60L);
        int hour = (int)(seconds / 60L / 60L - (long)day * 24L);
        int minute = (int)(seconds / 60L - (long)day * 24L * 60L - (long)hour * 60L);
        int second = (int)(seconds % 60L);
        int nano = duration.isNegative() ? duration.getNano() - 1000000000 : duration.getNano();
        byte[] bytes = new byte[]{(byte)((day ^= Integer.MIN_VALUE) >> 24), (byte)(day >> 16 & 0xFF), (byte)(day >> 8 & 0xFF), (byte)(day & 0xFF), (byte)((hour += 60) & 0xFF), (byte)((minute += 60) & 0xFF), (byte)((second += 60) & 0xFF), (byte)((nano ^= Integer.MIN_VALUE) >> 24), (byte)(nano >> 16 & 0xFF), (byte)(nano >> 8 & 0xFF), (byte)(nano & 0xFF)};
        return ReflectUtil.constructor((String)JAVA_TYPE_INTERVALDS, (Class[])new Class[]{byte[].class}).newInstance(new Object[]{bytes});
    }
}

