/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import manifold.sql.rt.api.DefaultTxScopeProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.SchemaType;
import manifold.sql.rt.api.TxScope;

public class ThreadLocalDefaultTxScopeProvider
implements DefaultTxScopeProvider {
    private final ThreadLocal<Map<Class<? extends SchemaType>, TxScope>> _defaultScopes = ThreadLocal.withInitial(() -> new LinkedHashMap());

    @Override
    public TxScope defaultScope(Class<? extends SchemaType> schemaClass) {
        Map<Class<? extends SchemaType>, TxScope> defaultScopes = this._defaultScopes.get();
        TxScope defaultScope = defaultScopes.get(schemaClass);
        if (defaultScope == null) {
            defaultScope = Dependencies.instance().getTxScopeProvider().newScope(schemaClass);
            defaultScopes.put(schemaClass, defaultScope);
        }
        return defaultScope;
    }

    @Override
    public void clear() {
        this._defaultScopes.remove();
    }
}

