/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import manifold.json.rt.api.DataBindings;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.TxScope;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;

public class Executor {
    private final String _sqlCommand;
    private final TxScope.RawChangeCtx _ctx;
    private final ColumnInfo[] _paramInfo;
    private final DataBindings _paramBindings;

    public Executor(TxScope.RawChangeCtx ctx, ColumnInfo[] paramInfo, DataBindings paramBindings, String sqlCommand) {
        this._ctx = ctx;
        this._paramInfo = paramInfo;
        this._paramBindings = paramBindings;
        this._sqlCommand = sqlCommand;
    }

    public int execute() throws SQLException {
        Connection txConnextion = this._ctx.getConnection();
        if (txConnextion == null) {
            throw new SQLException("Connection is null. Raw commands must execute using `addRawChange()`.");
        }
        try (PreparedStatement ps = txConnextion.prepareStatement(this._sqlCommand);){
            this.setParameters(ps);
            int n = ps.executeUpdate();
            return n;
        }
    }

    private void setParameters(PreparedStatement ps) throws SQLException {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Object param : this._paramBindings.values()) {
            ValueAccessor accessor = accProvider.get(this._paramInfo[i].getJdbcType());
            accessor.setParameter(ps, ++i, param);
        }
    }
}

