/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.util.ArrayList;
import java.util.List;

public class SqlScriptParser {
    private static final int EOF = -2;
    private final String _script;
    private final List<String> _commands;
    private int _pos = -1;

    public static List<String> getCommands(String script) {
        return new SqlScriptParser(script).parse(script);
    }

    private SqlScriptParser(String script) {
        this._script = script;
        this._commands = new ArrayList<String>();
    }

    private List<String> parse(String script) {
        this.next();
        while (!this.isEof()) {
            this.parseCommand();
        }
        return this._commands;
    }

    private void parseCommand() {
        int pos = this._pos;
        int blockDepth = 0;
        while (!this.isEof()) {
            while (this.eatComments() || this.eatWhitespace()) {
            }
            if (this.match(';') && blockDepth == 0) break;
            String word = this.matchWord();
            if (word.equalsIgnoreCase("BEGIN")) {
                ++blockDepth;
            } else if (word.equalsIgnoreCase("CASE")) {
                ++blockDepth;
            } else if (word.equalsIgnoreCase("END")) {
                if (--blockDepth < 0) {
                    throw new IllegalStateException("Unbalanced BEGIN/CASE END (see [*])\n\n" + new StringBuilder(this._script).insert(this._pos - 3, " [*]").toString());
                }
            } else if (word.equalsIgnoreCase("SEPARATOR")) {
                while (this.eatComments() || this.eatWhitespace()) {
                }
                this.matchStringLiteral();
            }
            this.matchNonWord();
        }
        String command = this._script.substring(pos, this.isEof() ? this._script.length() : this._pos - 1);
        if (!(command = command.trim()).isEmpty()) {
            this._commands.add(command);
        }
    }

    private boolean eatWhitespace() {
        boolean found = false;
        while (!this.isEof() && Character.isWhitespace(this.ch())) {
            found = true;
            this.next();
        }
        return found;
    }

    private boolean eatComments() {
        return this.eatLineComment() || this.eatMultiLineComment();
    }

    private boolean eatMultiLineComment() {
        boolean comment = false;
        while (!this.isEof()) {
            if (comment) {
                if (this.match("*/")) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match("/*")) break;
            comment = true;
        }
        return false;
    }

    private boolean eatLineComment() {
        boolean comment = false;
        while (!this.isEof()) {
            if (comment) {
                if (this.match('\n')) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match("--")) break;
            comment = true;
        }
        return false;
    }

    private boolean isEof() {
        return this._pos == -2;
    }

    private void next() {
        if (this.isEof()) {
            return;
        }
        if (this._pos + 1 == this._script.length()) {
            this._pos = -2;
            return;
        }
        ++this._pos;
    }

    private char ch() {
        return this._script.charAt(this._pos);
    }

    private boolean match(char c) {
        if (this.isEof()) {
            return false;
        }
        if (this.ch() == c) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean match(String s) {
        return this.match(s, false);
    }

    private boolean match(String s, boolean peek) {
        if (this.isEof()) {
            return false;
        }
        if (this._script.startsWith(s, this._pos)) {
            if (!peek) {
                this._pos += s.length();
                if (this._pos == this._script.length()) {
                    this._pos = -2;
                }
            }
            return true;
        }
        return false;
    }

    private String matchWord() {
        if (this.isEof()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (Character.isJavaIdentifierStart(this.ch())) {
            sb.append(this.ch());
            this.next();
            while (!this.isEof() && Character.isJavaIdentifierPart(this.ch())) {
                sb.append(this.ch());
                this.next();
            }
        }
        return sb.toString();
    }

    private String matchStringLiteral() {
        if (this.isEof()) {
            return "";
        }
        if (this.match('\'')) {
            StringBuilder sb = new StringBuilder();
            while (!this.match('\'')) {
                sb.append(this.ch());
                this.next();
            }
            return sb.toString();
        }
        return null;
    }

    private String matchNonWord() {
        if (this.isEof()) {
            return "";
        }
        while (this.eatWhitespace() || this.eatComments()) {
        }
        StringBuilder sb = new StringBuilder();
        while (!(this.isEof() || this.ch() == ';' || Character.isJavaIdentifierStart(this.ch()) || this.match("--", true) || this.match("/*", true))) {
            sb.append(this.ch());
            this.next();
        }
        return sb.toString();
    }
}

