/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class DateValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 91;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return LocalDate.class;
    }

    @Override
    public LocalDate getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Date date = rs.getDate(elem.getPosition());
        return date == null ? null : date.toLocalDate();
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof LocalDate) {
            ps.setDate(pos, Date.valueOf((LocalDate)value));
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

