/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class BlobValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 2004;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return byte[].class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Object res = rs.getObject(elem.getPosition());
        if (res == null) {
            return null;
        }
        if (res instanceof byte[]) {
            return res;
        }
        if (res instanceof Blob) {
            Blob blob = (Blob)res;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return byArray;
            }
            finally {
                blob.free();
            }
        }
        throw new SQLException("Expecting a blob or byte array, but found: " + res.getClass());
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            ps.setBinaryStream(pos, (InputStream)stream, bytes.length);
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

