/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class BitValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return -7;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        if (elem.getSize() > 1) {
            return byte[].class;
        }
        return elem.canBeNull() ? Boolean.class : Boolean.TYPE;
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        if (elem.getSize() > 1) {
            return rs.getBytes(elem.getPosition());
        }
        boolean value = rs.getBoolean(elem.getPosition());
        return !value && rs.wasNull() ? null : Boolean.valueOf(value);
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof byte[]) {
            ps.setBytes(pos, (byte[])value);
        } else if (value instanceof Boolean) {
            ps.setBoolean(pos, (Boolean)value);
        } else {
            ps.setObject(pos, value, 16);
        }
    }
}

