/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.SchemaType;
import manifold.sql.rt.api.TxScope;

public class DefaultTxScopeProvider {
    private static DefaultTxScopeProvider INSTANCE;
    private final ThreadLocal<Map<Class<? extends SchemaType>, TxScope>> _defaultScopes = ThreadLocal.withInitial(() -> new LinkedHashMap());

    private DefaultTxScopeProvider() {
    }

    public static DefaultTxScopeProvider instance() {
        return INSTANCE == null ? (INSTANCE = new DefaultTxScopeProvider()) : INSTANCE;
    }

    public TxScope defaultScope(Class<? extends SchemaType> schemaClass) {
        Map<Class<? extends SchemaType>, TxScope> defaultScopes = this._defaultScopes.get();
        TxScope defaultScope = defaultScopes.get(schemaClass);
        if (defaultScope == null) {
            defaultScope = Dependencies.instance().getTxScopeProvider().newScope(schemaClass);
            defaultScopes.put(schemaClass, defaultScope);
        }
        return defaultScope;
    }

    public void clear() {
        this._defaultScopes.remove();
    }
}

