/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.api.fs.IFile;
import manifold.api.util.cache.FqnCache;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.util.PropertyExpressionProcessor;

public class DbConfigImpl
implements DbConfig {
    public static final DbConfig EMPTY = new DbConfigImpl(null, (Bindings)DataBindings.EMPTY_BINDINGS, DbLocationProvider.Mode.Unknown);
    private final Bindings _bindings;
    private final Map<String, List<Consumer<Connection>>> _initializers = new HashMap<String, List<Consumer<Connection>>>();

    public DbConfigImpl(Function<String, FqnCache<IFile>> resByExt, Bindings bindings, DbLocationProvider.Mode mode) {
        this(resByExt, bindings, mode, null);
    }

    public DbConfigImpl(Function<String, FqnCache<IFile>> resByExt, Bindings bindings, DbLocationProvider.Mode mode, Function<String, String> exprHandler) {
        this.processUrl(resByExt, bindings, mode, "url", exprHandler);
        this.processUrl(resByExt, bindings, mode, "buildUrl", exprHandler);
        this._bindings = bindings;
    }

    private void processUrl(Function<String, FqnCache<IFile>> resByExt, Bindings bindings, DbLocationProvider.Mode mode, String key, Function<String, String> exprHandler) {
        String url = (String)bindings.get((Object)key);
        if (url == null) {
            return;
        }
        PropertyExpressionProcessor.Result result = PropertyExpressionProcessor.process(resByExt, url, mode, exprHandler);
        bindings.put((Object)key, (Object)result.url);
        this._initializers.put(result.url, result.initializers);
    }

    @Override
    public void init(Connection connection, String url) {
        List<Consumer<Connection>> consumers = this._initializers.get(url);
        for (Consumer<Connection> consumer : consumers) {
            consumer.accept(connection);
        }
    }

    @Override
    public String getName() {
        return (String)this._bindings.get((Object)"name");
    }

    @Override
    public String getCatalogName() {
        return (String)this._bindings.get((Object)"catalogName");
    }

    @Override
    public String getSchemaName() {
        return (String)this._bindings.get((Object)"schemaName");
    }

    @Override
    public String getPath() {
        return (String)this._bindings.get((Object)"path");
    }

    @Override
    public String getUrl() {
        return (String)this._bindings.get((Object)"url");
    }

    @Override
    public String getBuildUrl() {
        return (String)this._bindings.get((Object)"buildUrl");
    }

    @Override
    public String getUser() {
        return (String)this._bindings.get((Object)"user");
    }

    @Override
    public String getPassword() {
        return (String)this._bindings.get((Object)"password");
    }

    @Override
    public boolean isDefault() {
        Boolean isDefault = (Boolean)this._bindings.get((Object)"isDefault");
        return isDefault != null && isDefault != false;
    }

    @Override
    public String getSchemaPackage() {
        return (String)this._bindings.get((Object)"schemaPackage");
    }

    @Override
    public Bindings getProperties() {
        return (Bindings)this._bindings.get((Object)"properties");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbConfigImpl)) {
            return false;
        }
        DbConfigImpl dbConfig = (DbConfigImpl)o;
        return this._bindings.equals(dbConfig._bindings);
    }

    public int hashCode() {
        return this._bindings.hashCode();
    }
}

