/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import manifold.json.rt.Json;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.DbConfigProvider;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.impl.DbConfigImpl;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class DbConfigFinder
implements DbConfigProvider {
    public static final String DBCONFIG_EXT = ".dbconfig";
    private final Map<String, DbConfig> _configs = new LinkedHashMap<String, DbConfig>();

    @Override
    public DbConfig loadDbConfig(String configName, Class<?> ctx) {
        return this._configs.computeIfAbsent(configName, __ -> {
            Object module = JreUtil.isJava8() || ctx == null ? null : ReflectUtil.method((Object)ctx, (String)"getModule", (Class[])new Class[0]).invoke(new Object[0]);
            String moduleName = module != null && (Boolean)ReflectUtil.method((Object)module, (String)"isNamed", (Class[])new Class[0]).invoke(new Object[0]) != false ? (String)ReflectUtil.method((Object)module, (String)"getName", (Class[])new Class[0]).invoke(new Object[0]) : null;
            moduleName = moduleName == null ? null : moduleName.replace('.', '_');
            return DbConfigFinder.findConfig(moduleName, configName, ctx);
        });
    }

    @Override
    public void clear() {
        this._configs.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DbConfig findConfig(String module, String configName, Class<?> ctx) {
        InputStream stream = DbConfigFinder.findConfigInCurrentDir(configName);
        if (stream == null && ctx != null) {
            stream = DbConfigFinder.findConfigAsResource(module, configName, ctx);
        }
        if (stream == null) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Bindings bindings = (Bindings)Json.fromJson((String)StreamUtil.getContent((Reader)reader));
            bindings.put((Object)"name", (Object)configName);
            DbConfigImpl dbConfigImpl = new DbConfigImpl(null, bindings, DbLocationProvider.Mode.Runtime);
            return dbConfigImpl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream findConfigInCurrentDir(String configName) {
        File file = new File("./config/" + configName + DBCONFIG_EXT);
        if (!file.isFile() && !(file = new File("./" + configName + DBCONFIG_EXT)).isFile()) {
            return null;
        }
        try {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream findConfigAsResource(String module, String configName, Class<?> ctx) {
        InputStream stream = ctx.getResourceAsStream('/' + (module == null || module.isEmpty() ? "config/" : module + "/config/") + configName + DBCONFIG_EXT);
        if (stream == null && module != null && !module.isEmpty()) {
            stream = ctx.getResourceAsStream("/config/" + configName + DBCONFIG_EXT);
        }
        return stream;
    }
}

