/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import manifold.rt.api.util.ManClassUtil;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.KeyRef;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.SchemaType;
import manifold.sql.rt.api.TableInfo;
import manifold.sql.rt.api.TableRow;
import manifold.sql.rt.api.TxBindings;
import manifold.sql.rt.api.UpdateContext;

class BasicTxScope
implements OperableTxScope {
    private final DbConfig _dbConfig;
    private final Set<TableRow> _rows;
    private final ReentrantReadWriteLock _lock;

    public BasicTxScope(Class<? extends SchemaType> schemaClass) {
        this._dbConfig = Dependencies.instance().getDbConfigProvider().loadDbConfig(ManClassUtil.getShortClassName(schemaClass), schemaClass);
        this._rows = new LinkedHashSet<TableRow>();
        this._lock = new ReentrantReadWriteLock();
    }

    @Override
    public DbConfig getDbConfig() {
        return this._dbConfig;
    }

    @Override
    public Set<TableRow> getRows() {
        this._lock.readLock().lock();
        try {
            HashSet<TableRow> hashSet = new HashSet<TableRow>(this._rows);
            return hashSet;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    @Override
    public void addRow(TableRow item) {
        if (item == null) {
            throw new IllegalArgumentException("Item is null");
        }
        if (this.containsRow(item)) {
            return;
        }
        this._lock.writeLock().lock();
        try {
            this._rows.add(item);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    @Override
    public void removeRow(TableRow item) {
        this._lock.writeLock().lock();
        try {
            this._rows.remove(item);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsRow(TableRow item) {
        this._lock.readLock().lock();
        try {
            boolean bl = this._rows.contains(item);
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean commit() throws SQLException {
        this._lock.writeLock().lock();
        try {
            if (this._rows.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            TableRow first = (TableRow)this._rows.stream().findFirst().get();
            ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
            Throwable throwable = null;
            try (Connection c = cp.getConnection(this.getDbConfig().getName(), first.getClass());){
                c.setAutoCommit(false);
                HashSet<TableRow> visited = new HashSet<TableRow>();
                for (TableRow row : this._rows) {
                    this.doCrud(c, row, new LinkedHashMap<TableRow, Set<FkDep>>(), visited);
                }
                c.commit();
                for (TableRow row : this._rows) {
                    row.getBindings().commit();
                }
                this._rows.clear();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                try {
                    c.rollback();
                    for (TableRow row : this._rows) {
                        row.getBindings().dropHeldValues();
                    }
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            {
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    private void doCrud(Connection c, TableRow row, Map<TableRow, Set<FkDep>> unresolvedDeps, Set<TableRow> visited) throws SQLException {
        if (visited.contains(row)) {
            return;
        }
        visited.add(row);
        this.doFkDependenciesFirst(c, row, unresolvedDeps, visited);
        CrudProvider crud = Dependencies.instance().getCrudProvider();
        TableInfo ti = row.tableInfo();
        UpdateContext<TableRow> ctx = new UpdateContext<TableRow>(this, row, ti.getDdlTableName(), this._dbConfig.getName(), ti.getPkCols(), ti.getUkCols(), ti.getAllColsWithJdbcType());
        if (row.getBindings().isForInsert()) {
            crud.create(c, ctx);
        } else if (row.getBindings().isForUpdate()) {
            crud.update(c, ctx);
        } else if (row.getBindings().isForDelete()) {
            crud.delete(c, ctx);
        } else {
            throw new SQLException("Unexpected bindings kind, neither of insert/update/delete");
        }
        this.patchUnresolvedFkDeps(c, ctx, crud, unresolvedDeps.get(row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchUnresolvedFkDeps(Connection c, UpdateContext<TableRow> ctx, CrudProvider crud, Set<FkDep> unresolvedDeps) throws SQLException {
        if (unresolvedDeps == null) {
            return;
        }
        for (FkDep dep : unresolvedDeps) {
            Object pkId = dep.pkRow.getBindings().getHeldValue(dep.pkName);
            if (pkId == null) {
                throw new SQLException("pk value is null");
            }
            TxBindings fkBindings = dep.fkRow.getBindings();
            Object priorPkId = fkBindings.put(dep.fkName, pkId);
            try {
                crud.update(c, ctx);
            }
            finally {
                fkBindings.put(dep.fkName, priorPkId);
                fkBindings.holdValue(dep.fkName, pkId);
            }
        }
    }

    private void doFkDependenciesFirst(Connection c, TableRow row, Map<TableRow, Set<FkDep>> unresolvedDeps, Set<TableRow> visited) throws SQLException {
        for (Map.Entry entry : row.getBindings().entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof KeyRef)) continue;
            KeyRef ref = (KeyRef)value;
            TableRow pkTableRow = ref.getRef();
            FkDep fkDep = new FkDep(row, (String)entry.getKey(), pkTableRow, ref.getKeyColName());
            this.doCrud(c, pkTableRow, unresolvedDeps, visited);
            Object pkId = pkTableRow.getBindings().getHeldValue(fkDep.pkName);
            if (pkId != null) {
                row.getBindings().holdValue(fkDep.fkName, pkId);
                continue;
            }
            unresolvedDeps.computeIfAbsent(pkTableRow, __ -> new LinkedHashSet()).add(fkDep);
        }
    }

    private static class FkDep {
        final TableRow fkRow;
        final String fkName;
        final TableRow pkRow;
        final String pkName;

        public FkDep(TableRow fkRow, String fkName, TableRow pkRow, String pkName) {
            this.fkRow = fkRow;
            this.fkName = fkName;
            this.pkRow = pkRow;
            this.pkName = pkName;
        }
    }
}

