/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.KeyRef;
import manifold.sql.rt.api.QueryContext;
import manifold.sql.rt.api.Result;
import manifold.sql.rt.api.TableRow;
import manifold.sql.rt.api.TxBindings;
import manifold.sql.rt.api.UpdateContext;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.util.ManExceptionUtil;

public class BasicCrudProvider
implements CrudProvider {
    public static final String SQLITE_LAST_INSERT_ROWID = "last_insert_rowid()";

    @Override
    public <T extends TableRow> void create(Connection c, UpdateContext<T> ctx) {
        try {
            TableRow table = (TableRow)ctx.getTable();
            String[] allColumnNames = ctx.getAllColsWithJdbcType().keySet().toArray(new String[0]);
            String sql = this.makeInsertStmt(ctx.getDdlTableName(), table);
            try (PreparedStatement ps = c.prepareStatement(sql, allColumnNames);){
                this.setInsertParameters(ctx, ps);
                this.executeAndFetchRow(c, ctx, ps, table.getBindings());
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private <T extends TableRow> void setInsertParameters(UpdateContext<T> ctx, PreparedStatement ps) throws SQLException {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Map.Entry entry : ((TableRow)ctx.getTable()).getBindings().entrySet()) {
            int jdbcType = ctx.getAllColsWithJdbcType().get(entry.getKey());
            ValueAccessor accessor = accProvider.get(jdbcType);
            Object value = entry.getValue();
            value = BasicCrudProvider.patchFk(value, (String)entry.getKey(), ((TableRow)ctx.getTable()).getBindings());
            accessor.setParameter(ps, ++i, value);
        }
    }

    private static Object patchFk(Object value, String colName, TxBindings bindings) {
        if (value instanceof KeyRef) {
            Object heldFkValue = bindings.getHeldValue(colName);
            value = heldFkValue != null ? heldFkValue : Integer.valueOf(0);
        }
        return value;
    }

    private String makeInsertStmt(String ddlTableName, TableRow table) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(ddlTableName).append("(");
        int i = 0;
        Set entries = table.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            String colName = (String)entry.getKey();
            if (i++ > 0) {
                sql.append(", ");
            }
            sql.append(colName);
        }
        sql.append(")").append(" VALUES (");
        for (i = 0; i < entries.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append('?');
        }
        sql.append(")");
        return sql.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T extends TableRow> T readOne(QueryContext<T> ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T extends TableRow> List<T> readMany(QueryContext<T> ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T extends TableRow> String makeReadStatement(QueryContext<T> ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(ctx.getDdlTableName()).append(" WHERE ");
        int i = 0;
        for (String colName : ctx.getParams().keySet()) {
            if (i++ > 0) {
                sql.append(" AND ");
            }
            sql.append(colName).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public <T extends TableRow> void update(Connection c, UpdateContext<T> ctx) {
        try {
            TableRow table = (TableRow)ctx.getTable();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ").append(ctx.getDdlTableName()).append(" SET\n");
            int i = 0;
            Set<Map.Entry<String, Object>> changeEntries = table.getBindings().uncommittedChangesEntrySet();
            if (changeEntries.isEmpty()) {
                throw new SQLException("Expecting changed entries.");
            }
            for (Map.Entry<String, Object> entry : changeEntries) {
                if (i++ > 0) {
                    sql.append(",\n");
                }
                String colName = entry.getKey();
                sql.append("\"" + (String)colName + "\" = ?");
            }
            sql.append("\nWHERE ");
            Set<String> allColNames = ctx.getAllColsWithJdbcType().keySet();
            Set<String> whereColumns = !ctx.getPkCols().isEmpty() ? ctx.getPkCols() : (!ctx.getUkCols().isEmpty() ? ctx.getUkCols() : allColNames);
            if (!whereColumns.isEmpty()) {
                i = 0;
                for (String whereCol : whereColumns) {
                    if (i++ > 0) {
                        sql.append(", ");
                    }
                    sql.append("\"" + whereCol + "\" = ?");
                }
            } else {
                throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
            }
            try (PreparedStatement ps = c.prepareStatement(sql.toString(), allColNames.toArray(new String[0]));){
                this.setUpdateParameters(ctx, whereColumns, ps);
                this.executeAndFetchRow(c, ctx, ps, table.getBindings());
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private <T extends TableRow> void setUpdateParameters(UpdateContext<T> ctx, Set<String> whereColumns, PreparedStatement ps) throws SQLException {
        Object value;
        ValueAccessor accessor;
        int paramIndex = 0;
        Set<Map.Entry<String, Object>> changeEntries = ((TableRow)ctx.getTable()).getBindings().uncommittedChangesEntrySet();
        if (changeEntries.isEmpty()) {
            throw new SQLException("Expecting changed entries.");
        }
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Map.Entry<String, Object> entry : changeEntries) {
            accessor = accProvider.get(ctx.getAllColsWithJdbcType().get(entry.getKey()));
            value = entry.getValue();
            accessor.setParameter(ps, ++paramIndex, value);
        }
        if (!whereColumns.isEmpty()) {
            for (String whereColumn : whereColumns) {
                accessor = accProvider.get(ctx.getAllColsWithJdbcType().get(whereColumn));
                value = ((TableRow)ctx.getTable()).getBindings().getPersistedStateValue(whereColumn);
                accessor.setParameter(ps, ++paramIndex, value);
            }
        } else {
            throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
        }
    }

    private <T extends TableRow> void setDeleteParameters(UpdateContext<T> ctx, Set<String> whereColumns, PreparedStatement ps) throws SQLException {
        int paramIndex = 0;
        if (!whereColumns.isEmpty()) {
            ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
            for (String whereColumn : whereColumns) {
                ValueAccessor accessor = accProvider.get(ctx.getAllColsWithJdbcType().get(whereColumn));
                Object value = ((TableRow)ctx.getTable()).getBindings().getPersistedStateValue(whereColumn);
                accessor.setParameter(ps, ++paramIndex, value);
            }
        } else {
            throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
        }
    }

    private <T extends TableRow> void executeAndFetchRow(Connection c, UpdateContext<T> ctx, PreparedStatement ps, TxBindings table) throws SQLException {
        int result = ps.executeUpdate();
        if (result != 1) {
            throw new SQLException("Expecting a single row result for Update/Insert, got " + result);
        }
        DataBindings reflectedRow = DataBindings.EMPTY_BINDINGS;
        try (ResultSet resultSet = ps.getGeneratedKeys();){
            Result<IBindingsBacked> resultRow = new Result<IBindingsBacked>(ctx.getAllColsWithJdbcType(), resultSet, rowBindings -> () -> rowBindings);
            Iterator<IBindingsBacked> iterator = resultRow.iterator();
            if (iterator.hasNext()) {
                reflectedRow = iterator.next().getBindings();
                if (iterator.hasNext()) {
                    throw new SQLException("Expecting a single row, found more.");
                }
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        if (reflectedRow.isEmpty() && ctx.getPkCols().isEmpty()) {
            return;
        }
        if ((reflectedRow = this.maybeFetchInsertedRow(c, ctx, table, (Bindings)reflectedRow)).isEmpty()) {
            throw new SQLException("Failed to reflect newly inserted row.");
        }
        table.holdValues((Bindings)reflectedRow);
    }

    private <T extends TableRow> Bindings maybeFetchInsertedRow(Connection c, UpdateContext<T> ctx, TxBindings bindings, Bindings reflectedRow) throws SQLException {
        int[] paramTypes;
        DataBindings params = new DataBindings();
        if (reflectedRow.containsKey((Object)SQLITE_LAST_INSERT_ROWID)) {
            params.put("_rowid_", reflectedRow.get((Object)SQLITE_LAST_INSERT_ROWID));
            paramTypes = new int[]{4};
        } else if (reflectedRow.isEmpty()) {
            Set<String> pkCols = ctx.getPkCols();
            if (pkCols.isEmpty()) {
                return reflectedRow;
            }
            Map<String, Integer> jdbcTypes = ctx.getAllColsWithJdbcType();
            paramTypes = new int[pkCols.size()];
            int i = 0;
            for (String pkCol : pkCols) {
                Object pkValue = bindings.get(pkCol);
                if (pkValue == null) {
                    return reflectedRow;
                }
                params.put(pkCol, pkValue);
                paramTypes[i++] = jdbcTypes.get(pkCol);
            }
        } else {
            return reflectedRow;
        }
        QueryContext queryContext = new QueryContext(ctx.getTxScope(), null, ctx.getDdlTableName(), paramTypes, (Bindings)params, ctx.getConfigName(), null);
        String sql = this.makeReadStatement(queryContext);
        PreparedStatement ps = c.prepareStatement(sql);
        Object object = null;
        try {
            this.setQueryParameters(queryContext, ps);
            try (ResultSet resultSet = ps.executeQuery();){
                Result<IBindingsBacked> resultRow = new Result<IBindingsBacked>(ctx.getAllColsWithJdbcType(), resultSet, rowBindings -> () -> rowBindings);
                Iterator<IBindingsBacked> iterator = resultRow.iterator();
                if (!iterator.hasNext()) {
                    throw new SQLException("Expecting a single row, found none.");
                }
                reflectedRow = iterator.next().getBindings();
                if (iterator.hasNext()) {
                    throw new SQLException("Expecting a single row, found more.");
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (object != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
        return reflectedRow;
    }

    @Override
    public <T extends TableRow> void delete(Connection c, UpdateContext<T> ctx) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ").append(ctx.getDdlTableName()).append(" WHERE\n");
            Set<String> allColNames = ctx.getAllColsWithJdbcType().keySet();
            Set<String> whereColumns = !ctx.getPkCols().isEmpty() ? ctx.getPkCols() : (!ctx.getUkCols().isEmpty() ? ctx.getUkCols() : allColNames);
            if (!whereColumns.isEmpty()) {
                int i = 0;
                for (String whereCol : whereColumns) {
                    if (i++ > 0) {
                        sql.append(", ");
                    }
                    sql.append("\"" + whereCol + "\" = ?");
                }
            } else {
                throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
            }
            PreparedStatement ps = c.prepareStatement(sql.toString(), allColNames.toArray(new String[0]));
            Object object = null;
            try {
                this.setDeleteParameters(ctx, whereColumns, ps);
                int result = ps.executeUpdate();
                if (result != 1) {
                    throw new SQLException("Expecting a single row result for Delete, got " + result);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (object != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private <T extends TableRow> void setQueryParameters(QueryContext<T> ctx, PreparedStatement ps) throws SQLException {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Object param : ctx.getParams().values()) {
            ValueAccessor accessor = accProvider.get(ctx.getJdbcParamTypes()[i]);
            accessor.setParameter(ps, ++i, param);
        }
    }
}

