/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.DbConfigProvider;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.TxScopeProvider;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.sql.rt.impl.BasicCrudProvider;
import manifold.sql.rt.impl.BasicTxScopeProvider;
import manifold.sql.rt.impl.DbConfigFinder;
import manifold.sql.rt.impl.HikariConnectionProvider;
import manifold.sql.rt.impl.ResourceDbLocationProvider;
import manifold.sql.rt.impl.accessors.DefaultValueAccessorProvider;

public class DefaultDependencies
implements Dependencies {
    private final Map<Class<?>, Object> _instances = new ConcurrentHashMap();

    @Override
    public DbConfigProvider getDbConfigProvider() {
        return this.fetch(DbConfigFinder.class);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.fetch(HikariConnectionProvider.class);
    }

    @Override
    public CrudProvider getCrudProvider() {
        return this.fetch(BasicCrudProvider.class);
    }

    @Override
    public DbLocationProvider getDbLocationProvider() {
        return this.fetch(ResourceDbLocationProvider.class);
    }

    @Override
    public TxScopeProvider getTxScopeProvider() {
        return this.fetch(BasicTxScopeProvider.class);
    }

    @Override
    public ValueAccessorProvider getValueAccessorProvider() {
        return this.fetch(DefaultValueAccessorProvider.class);
    }

    @Override
    public <T> T fetch(Class<T> cls) {
        return (T)this._instances.computeIfAbsent(cls, __ -> {
            try {
                return cls.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

