/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValueAccessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(ValueAccessor.class);

    public int getJdbcType();

    public Class<?> getJavaType(BaseElement var1);

    public Object getRowValue(ResultSet var1, BaseElement var2) throws SQLException;

    public void setParameter(PreparedStatement var1, int var2, Object var3) throws SQLException;

    default public Class<?> getClassForColumnClassName(BaseElement elem, Class<?> defaultClass) {
        String className = elem.getColumnClassName();
        if (className != null && !className.equals(Object.class.getTypeName())) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Failed to access class '" + className + "' for '" + this.getClass().getSimpleName() + "'", (Throwable)cnfe);
            }
        }
        return defaultClass;
    }
}

