/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.util.ManExceptionUtil;

class ResultColumn
implements BaseElement {
    private final ResultSetMetaData _metaData;
    private final int _pos;

    public ResultColumn(ResultSetMetaData metaData, int pos) {
        this._metaData = metaData;
        this._pos = pos;
    }

    @Override
    public String getName() {
        try {
            return this._metaData.getColumnLabel(this._pos);
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    @Override
    public int getPosition() {
        return this._pos;
    }

    @Override
    public boolean isNullable() {
        try {
            return this._metaData.isNullable(this._pos) == 1;
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    @Override
    public int getSize() {
        try {
            return this._metaData.getPrecision(this._pos);
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }
}

