/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.sql.rt.api.BasicTxBindings;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.ResultColumn;
import manifold.sql.rt.api.TableRow;
import manifold.sql.rt.api.TxBindings;
import manifold.sql.rt.api.TxScope;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.util.ManExceptionUtil;

public class Result<R extends IBindingsBacked>
implements Iterable<R> {
    private final List<R> _results = new ArrayList<R>();

    public Result(TxScope txScope, ResultSet resultSet, Function<TxBindings, R> makeRow) {
        this.rip(null, resultSet, rowBindings -> new BasicTxBindings(txScope, BasicTxBindings.TxKind.Update, (Bindings)rowBindings), makeRow);
    }

    public Result(ResultSet resultSet, Function<Bindings, R> makeRow) {
        this((Map<String, Integer>)null, resultSet, makeRow);
    }

    public Result(Map<String, Integer> allColsWithJdbcType, ResultSet resultSet, Function<Bindings, R> makeRow) {
        this.rip(allColsWithJdbcType, resultSet, rowBindings -> rowBindings, makeRow);
    }

    private <B extends Bindings> void rip(Map<String, Integer> allColsWithJdbcType, ResultSet resultSet, Function<DataBindings, B> makeBindings, Function<B, R> makeRow) {
        try {
            ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ValueAccessor[] accessors = Result.buildAccessors(allColsWithJdbcType, accProvider, metaData, columnCount);
            boolean isOnRow = resultSet.next();
            while (isOnRow) {
                DataBindings row = new DataBindings();
                for (int i = 1; i <= columnCount; ++i) {
                    String column = metaData.getColumnLabel(i);
                    Object value = accessors[i - 1].getRowValue(resultSet, new ResultColumn(metaData, i));
                    row.put(column, value);
                }
                IBindingsBacked resultRow = (IBindingsBacked)makeRow.apply(makeBindings.apply(row));
                if (resultRow instanceof TableRow) {
                    ((TableRow)resultRow).getBindings().setOwner((TableRow)resultRow);
                }
                this._results.add(resultRow);
                isOnRow = resultSet.next();
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private static ValueAccessor[] buildAccessors(Map<String, Integer> allColsWithJdbcType, ValueAccessorProvider accProvider, ResultSetMetaData metaData, int columnCount) throws SQLException {
        ValueAccessor[] accessors = new ValueAccessor[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String colName;
            Integer jdbcType = null;
            if (allColsWithJdbcType != null && (colName = metaData.getColumnName(i + 1)) != null) {
                jdbcType = allColsWithJdbcType.get(colName);
            }
            if (jdbcType == null) {
                jdbcType = metaData.getColumnType(i + 1);
            }
            accessors[i] = accProvider.get(jdbcType);
        }
        return accessors;
    }

    @Override
    public Iterator<R> iterator() {
        return this._results.iterator();
    }

    public List<R> toList() {
        return this._results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result result = (Result)o;
        return this._results.equals(result._results);
    }

    public int hashCode() {
        return Objects.hash(this._results);
    }

    public String toString() {
        if (this._results.isEmpty()) {
            return "<empty>";
        }
        StringBuilder header = new StringBuilder();
        for (String title : ((IBindingsBacked)this._results.get(0)).getBindings().keySet()) {
            if (header.length() > 0) {
                header.append(", ");
            }
            header.append(title).append("\n");
        }
        StringBuilder rows = new StringBuilder();
        for (IBindingsBacked value : this._results) {
            rows.append(value.display()).append("\n");
        }
        return header.toString() + rows;
    }
}

