/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AngleUnit;
import manifold.science.measures.Frequency;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class FrequencyUnit
extends AbstractQuotientUnit<AngleUnit, TimeUnit, Frequency, FrequencyUnit> {
    private static final UnitCache<FrequencyUnit> CACHE = new UnitCache();
    public static final FrequencyUnit BASE = FrequencyUnit.get(AngleUnit.Radian, TimeUnit.Second);
    public static final FrequencyUnit Hertz = FrequencyUnit.get(AngleUnit.Turn, TimeUnit.Second, CoercionConstants.r.postfixBind(1), "Hertz", "Hz");
    public static final FrequencyUnit RPM = FrequencyUnit.get(AngleUnit.Turn, TimeUnit.Minute, CoercionConstants.r.postfixBind(1), "RPM", "rpm");

    public static FrequencyUnit get(AngleUnit angleUnit, TimeUnit timeUnit) {
        return FrequencyUnit.get(angleUnit, timeUnit, null, null, null);
    }

    public static FrequencyUnit get(AngleUnit angleUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        FrequencyUnit unit = new FrequencyUnit(angleUnit, timeUnit, factor, name, symbol);
        return (FrequencyUnit)CACHE.get(unit);
    }

    private FrequencyUnit(AngleUnit angleUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super(angleUnit, timeUnit, factor, name, symbol);
    }

    @Override
    public Frequency makeDimension(Number amount) {
        return new Frequency(Rational.get(amount), this);
    }

    public AngleUnit getAngleUnit() {
        return (AngleUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }
}

