/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Mass;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Time;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.Rational;

public final class Acceleration
extends AbstractMeasure<AccelerationUnit, Acceleration> {
    public Acceleration(Rational value, AccelerationUnit unit, AccelerationUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Acceleration(Rational value, AccelerationUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public AccelerationUnit getBaseUnit() {
        return AccelerationUnit.BASE;
    }

    @Override
    public Acceleration make(Rational value, AccelerationUnit unit, AccelerationUnit displayUnit) {
        return new Acceleration(value, unit, displayUnit);
    }

    @Override
    public Acceleration make(Rational value, AccelerationUnit unit) {
        return new Acceleration(value, unit);
    }

    public Force times(Mass mass) {
        return new Force(this.toBaseNumber().times(mass.toBaseNumber()), ForceUnit.BASE, ForceUnit.get((MassUnit)mass.getDisplayUnit(), (AccelerationUnit)this.getDisplayUnit()));
    }

    public Velocity times(Time time) {
        return new Velocity(this.toBaseNumber().times(time.toBaseNumber()), VelocityUnit.BASE, ((AccelerationUnit)this.getDisplayUnit()).getVelocityUnit());
    }
}

