/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.api;

import manifold.science.api.AbstractBinaryUnit;
import manifold.science.api.Dimension;
import manifold.science.api.Unit;
import manifold.science.util.Rational;

public abstract class AbstractQuotientUnit<A extends Unit, B extends Unit, D extends Dimension<D>, U extends AbstractQuotientUnit<A, B, D, U>>
extends AbstractBinaryUnit<A, B, D, U> {
    protected AbstractQuotientUnit(A leftUnit, B rightUnit) {
        this(leftUnit, rightUnit, null, null, null);
    }

    protected AbstractQuotientUnit(A leftUnit, B rightUnit, Rational factor) {
        this(leftUnit, rightUnit, factor, null, null);
    }

    protected AbstractQuotientUnit(A leftUnit, B rightUnit, Rational factor, String name) {
        this(leftUnit, rightUnit, factor, name, null);
    }

    protected AbstractQuotientUnit(A leftUnit, B rightUnit, Rational factor, String name, String symbol) {
        super(leftUnit, rightUnit, factor, name, symbol);
    }

    @Override
    public String getName() {
        return super.getName() == null ? this.getLeftUnit().getName() + "/" + this.getRightUnit().getName() : super.getName();
    }

    @Override
    public String getSymbol() {
        return super.getSymbol() == null ? this.getLeftUnit().getSymbol() + "/" + this.getRightUnit().getSymbol() : super.getSymbol();
    }

    @Override
    public String getFullName() {
        return this.getLeftUnit().getFullName() + "/" + this.getRightUnit().getFullName();
    }

    @Override
    public String getFullSymbol() {
        return this.getLeftUnit().getFullSymbol() + "/" + this.getRightUnit().getFullSymbol();
    }

    @Override
    public Rational toBaseUnits(Rational myUnits) {
        return this.getLeftUnit().toBaseUnits(Rational.ONE).div(this.getRightUnit().toBaseUnits(Rational.ONE)).times(myUnits).times(this.getFactor());
    }

    @Override
    public Rational toNumber() {
        return this.getLeftUnit().toNumber().div(this.getRightUnit().toNumber());
    }

    public A times(B a) {
        return this.getLeftUnit();
    }
}

