/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import manifold.collections.api.range.Sequential;
import manifold.ext.rt.api.ComparableUsing;

public final class Rational
extends Number
implements Sequential<Rational, Rational, Void>,
ComparableUsing<Rational>,
Serializable {
    private static final int VERSION_1 = 1;
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE, true);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE, true);
    public static final Rational TEN = new Rational(BigInteger.valueOf(10L), BigInteger.ONE, true);
    public static final Rational HALF = new Rational(BigInteger.ONE, BigInteger.valueOf(2L), true);
    private final BigInteger _numerator;
    private final BigInteger _denominator;
    private boolean _reduced;

    public static Rational get(int numerator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static Rational get(int numerator, int denominator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational get(long numerator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static Rational get(long numerator, long denominator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational get(float f) {
        return Rational.get(Float.toString(f));
    }

    public static Rational get(double d) {
        return Rational.get(Double.toString(d));
    }

    public static Rational get(BigInteger numerator) {
        return Rational.get(numerator, BigInteger.ONE);
    }

    public static Rational get(Number numerator) {
        return Rational.get(String.valueOf(numerator));
    }

    public static Rational get(String decimal) {
        int iDiv = decimal.indexOf("/");
        if (iDiv > 0) {
            String numerator = decimal.substring(0, iDiv).trim();
            String denominator = decimal.substring(iDiv + 1).trim();
            boolean numeratorIsDecimal = Rational.isDecimalString(numerator);
            boolean denominatorIsDecimal = Rational.isDecimalString(denominator);
            if (numeratorIsDecimal) {
                if (denominatorIsDecimal) {
                    return Rational.get(new BigDecimal(numerator)).div(Rational.get(new BigDecimal(denominator)));
                }
                return Rational.get(new BigDecimal(numerator)).div(new BigInteger(denominator));
            }
            if (denominatorIsDecimal) {
                return Rational.get(new BigInteger(numerator)).div(Rational.get(new BigDecimal(denominator)));
            }
            return Rational.get(new BigInteger(numerator), new BigInteger(denominator));
        }
        if (Rational.isDecimalString(decimal)) {
            return Rational.get(new BigDecimal(decimal));
        }
        return Rational.get(new BigInteger(decimal));
    }

    private static boolean isDecimalString(String decimal) {
        return decimal.indexOf(46) >= 0 || decimal.indexOf(101) > 0 || decimal.indexOf(69) > 0;
    }

    public static Rational get(BigDecimal bd) {
        BigInteger denominator;
        BigInteger numerator;
        int scale = bd.scale();
        if (scale >= 0) {
            numerator = bd.unscaledValue();
            denominator = BigInteger.TEN.pow(scale);
        } else {
            numerator = bd.unscaledValue().multiply(BigInteger.TEN.pow(-scale));
            denominator = BigInteger.ONE;
        }
        return Rational.get(numerator, denominator);
    }

    public static Rational get(BigInteger numerator, BigInteger denominator) {
        return Rational.get(numerator, denominator, false);
    }

    private static Rational get(BigInteger numerator, BigInteger denominator, boolean reduced) {
        if (numerator.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        if (numerator.equals(BigInteger.ONE) && denominator.equals(BigInteger.ONE)) {
            return ONE;
        }
        return new Rational(numerator, denominator, reduced);
    }

    private Rational(BigInteger numerator, BigInteger denominator, boolean reduced) {
        if (denominator.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (numerator.signum() == 0) {
            this._numerator = BigInteger.ZERO;
            this._denominator = BigInteger.ONE;
        } else {
            if (denominator.signum() == -1) {
                numerator = numerator.negate();
                denominator = denominator.negate();
            }
            this._numerator = numerator;
            this._denominator = denominator;
        }
        this._reduced = reduced;
    }

    public boolean isReduced() {
        return this._reduced || this.reduce().isReduced() && this._reduced;
    }

    public Rational reduce() {
        if (!this._reduced) {
            BigInteger gcd = this._numerator.gcd(this._denominator);
            if (gcd.compareTo(BigInteger.ONE) > 0) {
                return Rational.get(this._numerator.divide(gcd), this._denominator.divide(gcd), true);
            }
            this._reduced = true;
        }
        return this;
    }

    public BigInteger getNumerator() {
        return this._numerator;
    }

    public BigInteger getDenominator() {
        return this._denominator;
    }

    public BigInteger wholePart() {
        return this._numerator.divide(this._denominator);
    }

    public Rational fractionPart() {
        BigInteger rem = this._numerator.remainder(this._denominator);
        if (rem.signum() == 0) {
            return ZERO;
        }
        return Rational.get(rem, this._denominator);
    }

    @Override
    public int intValue() {
        return this._numerator.divide(this._denominator).intValue();
    }

    @Override
    public long longValue() {
        return this._numerator.divide(this._denominator).longValue();
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    public BigInteger toBigInteger() {
        return this.toBigDecimal().toBigInteger();
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(MathContext.DECIMAL128);
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        return this.equals(ZERO) ? BigDecimal.ZERO : new BigDecimal(this._numerator).divide(new BigDecimal(this._denominator), mc);
    }

    public Rational plus(int i) {
        return i == 0 ? this : this.plus(Rational.get(i));
    }

    public Rational plus(long l) {
        return l == 0L ? this : this.plus(Rational.get(l));
    }

    public Rational plus(float f) {
        return f == 0.0f ? this : this.plus(Rational.get(f));
    }

    public Rational plus(double d) {
        return d == 0.0 ? this : this.plus(Rational.get(d));
    }

    public Rational plus(BigInteger bg) {
        if (this.signum() == 0) {
            return Rational.get(bg);
        }
        if (bg.signum() == 0) {
            return this;
        }
        return bg.equals(BigInteger.ZERO) ? this : Rational.get(this._numerator.add(this._denominator.multiply(bg)), this._denominator);
    }

    public Rational plus(BigDecimal bd) {
        return bd.signum() == 0 ? this : this.plus(Rational.get(bd));
    }

    public Rational plus(Rational rational) {
        BigInteger denominator;
        BigInteger numerator;
        if (rational.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return rational;
        }
        if (this._denominator.equals(rational._denominator)) {
            numerator = this._numerator.add(rational._numerator);
            denominator = this._denominator;
        } else {
            numerator = this._numerator.multiply(rational._denominator).add(rational._numerator.multiply(this._denominator));
            denominator = this._denominator.multiply(rational._denominator);
        }
        return numerator.signum() == 0 ? ZERO : Rational.get(numerator, denominator);
    }

    public Rational plus(Number n) {
        if (n instanceof Rational) {
            return this.plus((Rational)n);
        }
        if (n instanceof BigDecimal) {
            return this.plus((BigDecimal)n);
        }
        if (n instanceof BigInteger) {
            return this.plus((BigInteger)n);
        }
        if (n instanceof Double) {
            return this.plus((Double)n);
        }
        if (n instanceof Float) {
            return this.plus(((Float)n).floatValue());
        }
        if (n instanceof Integer) {
            return this.plus((Integer)n);
        }
        if (n instanceof Long) {
            return this.plus((Long)n);
        }
        return this.plus(Rational.get(String.valueOf(n)));
    }

    public Rational minus(int i) {
        return this.minus(BigInteger.valueOf(i));
    }

    public Rational minus(long l) {
        return this.minus(BigInteger.valueOf(l));
    }

    public Rational minus(float f) {
        return this.minus(Rational.get(f));
    }

    public Rational minus(double d) {
        return this.minus(Rational.get(d));
    }

    public Rational minus(BigInteger bi) {
        if (bi.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return Rational.get(bi.negate());
        }
        return Rational.get(this._numerator.subtract(this._denominator.multiply(bi)), this._denominator);
    }

    public Rational minus(BigDecimal bd) {
        return bd.signum() == 0 ? this : this.minus(Rational.get(bd));
    }

    public Rational minus(Rational rational) {
        BigInteger denominator;
        BigInteger numerator;
        if (rational.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return rational.unaryMinus();
        }
        if (this._denominator.equals(rational._denominator)) {
            numerator = this._numerator.subtract(rational._numerator);
            denominator = this._denominator;
        } else {
            numerator = this._numerator.multiply(rational._denominator).subtract(rational._numerator.multiply(this._denominator));
            denominator = this._denominator.multiply(rational._denominator);
        }
        return numerator.signum() == 0 ? ZERO : Rational.get(numerator, denominator);
    }

    public Rational minus(Number n) {
        if (n instanceof Rational) {
            return this.minus((Rational)n);
        }
        if (n instanceof BigDecimal) {
            return this.minus((BigDecimal)n);
        }
        if (n instanceof BigInteger) {
            return this.minus((BigInteger)n);
        }
        if (n instanceof Double) {
            return this.minus((Double)n);
        }
        if (n instanceof Float) {
            return this.minus(((Float)n).floatValue());
        }
        if (n instanceof Integer) {
            return this.minus((Integer)n);
        }
        if (n instanceof Long) {
            return this.minus((Long)n);
        }
        return this.minus(Rational.get(String.valueOf(n)));
    }

    public Rational times(int i) {
        if (i == 0 || this.signum() == 0) {
            return ZERO;
        }
        return this.times(BigInteger.valueOf(i));
    }

    public Rational times(long l) {
        if (l == 0L || this.signum() == 0) {
            return ZERO;
        }
        return this.times(BigInteger.valueOf(l));
    }

    public Rational times(float f) {
        if (f == 0.0f || this.signum() == 0) {
            return ZERO;
        }
        return this.times(Rational.get(f));
    }

    public Rational times(double d) {
        if (d == 0.0 || this.signum() == 0) {
            return ZERO;
        }
        return this.times(Rational.get(d));
    }

    public Rational times(BigInteger bi) {
        if (this.signum() == 0 || bi.signum() == 0) {
            return ZERO;
        }
        return Rational.get(bi.multiply(this._numerator), this._denominator);
    }

    public Rational times(BigDecimal bd) {
        if (this.signum() == 0 || bd.signum() == 0) {
            return ZERO;
        }
        return this.times(Rational.get(bd));
    }

    public Rational times(Rational rational) {
        if (this.signum() == 0 || rational.signum() == 0) {
            return ZERO;
        }
        return Rational.get(this._numerator.multiply(rational._numerator), this._denominator.multiply(rational._denominator));
    }

    public Rational times(Number n) {
        if (n instanceof Rational) {
            return this.times((Rational)n);
        }
        if (n instanceof BigDecimal) {
            return this.times((BigDecimal)n);
        }
        if (n instanceof BigInteger) {
            return this.times((BigInteger)n);
        }
        if (n instanceof Double) {
            return this.times((Double)n);
        }
        if (n instanceof Float) {
            return this.times(((Float)n).floatValue());
        }
        if (n instanceof Integer) {
            return this.times((Integer)n);
        }
        if (n instanceof Long) {
            return this.times((Long)n);
        }
        return this.times(Rational.get(String.valueOf(n)));
    }

    public Rational div(int i) {
        return this.div(BigInteger.valueOf(i));
    }

    public Rational div(long l) {
        return this.div(BigInteger.valueOf(l));
    }

    public Rational div(float f) {
        return this.div(Rational.get(f));
    }

    public Rational div(double d) {
        return this.div(Rational.get(d));
    }

    public Rational div(BigInteger bi) {
        if (bi.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        return Rational.get(this._numerator, this._denominator.multiply(bi));
    }

    public Rational div(BigDecimal bd) {
        if (bd.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        return this.div(Rational.get(bd));
    }

    public Rational div(Rational rational) {
        if (rational.equals(ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        return this.times(rational.invert());
    }

    public Rational div(Number n) {
        if (n instanceof Rational) {
            return this.div((Rational)n);
        }
        if (n instanceof BigDecimal) {
            return this.div((BigDecimal)n);
        }
        if (n instanceof BigInteger) {
            return this.div((BigInteger)n);
        }
        if (n instanceof Double) {
            return this.div((Double)n);
        }
        if (n instanceof Float) {
            return this.div(((Float)n).floatValue());
        }
        if (n instanceof Integer) {
            return this.div((Integer)n);
        }
        if (n instanceof Long) {
            return this.div((Long)n);
        }
        return this.div(Rational.get(String.valueOf(n)));
    }

    public Rational rem(int i) {
        return this.rem(BigInteger.valueOf(i));
    }

    public Rational rem(long l) {
        return this.rem(BigInteger.valueOf(l));
    }

    public Rational rem(float f) {
        return this.rem(Rational.get(f));
    }

    public Rational rem(double d) {
        return this.rem(Rational.get(d));
    }

    public Rational rem(BigInteger bi) {
        if (bi.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        return this.rem(Rational.get(bi));
    }

    public Rational rem(BigDecimal bd) {
        if (bd.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        return this.rem(Rational.get(bd));
    }

    public Rational rem(Rational rational) {
        Rational quotient = this.div(rational);
        return this.minus(rational.times(quotient.toBigInteger())).abs();
    }

    public Rational rem(Number n) {
        if (n instanceof Rational) {
            return this.rem((Rational)n);
        }
        if (n instanceof BigDecimal) {
            return this.rem((BigDecimal)n);
        }
        if (n instanceof BigInteger) {
            return this.rem((BigInteger)n);
        }
        if (n instanceof Double) {
            return this.rem((Double)n);
        }
        if (n instanceof Float) {
            return this.rem(((Float)n).floatValue());
        }
        if (n instanceof Integer) {
            return this.rem((Integer)n);
        }
        if (n instanceof Long) {
            return this.rem((Long)n);
        }
        return this.rem(Rational.get(String.valueOf(n)));
    }

    public Rational unaryMinus() {
        return Rational.get(this._numerator.negate(), this._denominator);
    }

    public Rational inc() {
        return this.plus(ONE);
    }

    public Rational dec() {
        return this.minus(ONE);
    }

    public Rational invert() {
        return Rational.get(this._denominator, this._numerator);
    }

    public Rational abs() {
        return this.signum() >= 0 ? this : this.unaryMinus();
    }

    public Rational pow(int exponent) {
        if (this.signum() == 0) {
            return exponent == 0 ? ONE : this;
        }
        return Rational.get(this._numerator.pow(exponent), this._denominator.pow(exponent));
    }

    @Deprecated
    public Rational sqrt() {
        return Rational.get(Math.sqrt(this.doubleValue()));
    }

    public boolean isInteger() {
        return this._denominator.equals(BigInteger.ONE);
    }

    public Rational nextInSequence(Rational step, Void unit) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? ONE : step;
        return this.plus(step);
    }

    public Rational nextNthInSequence(Rational step, Void unit, int index) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? ONE : step;
        return this.plus(step.times(index));
    }

    public Rational previousInSequence(Rational step, Void unit) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? ONE : step;
        return this.minus(step);
    }

    public Rational previousNthInSequence(Rational step, Void unit, int index) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? ONE : step;
        return this.minus(step.times(index));
    }

    public int signum() {
        return this._numerator.signum();
    }

    public int compareTo(Rational that) {
        int thatSign;
        if (that == null || that != null && null != null && that.compareToUsing(null, ComparableUsing.Operator.EQ)) {
            throw new NullPointerException("Null argument for comparison");
        }
        if (this == that) {
            return 0;
        }
        int thisSign = this.signum();
        if (thisSign != (thatSign = that.signum()) || thisSign == 0) {
            return thisSign - thatSign;
        }
        BigInteger crossNum = this._numerator.multiply(that._denominator);
        BigInteger crossDen = this._denominator.multiply(that._numerator);
        return crossNum.compareTo(crossDen);
    }

    public ComparableUsing.EqualityMode equalityMode() {
        return ComparableUsing.EqualityMode.CompareTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rational me = this.reduce();
        Rational that = ((Rational)o).reduce();
        if (!me._denominator.equals(that._denominator)) {
            return false;
        }
        return me._numerator.equals(that._numerator);
    }

    public int hashCode() {
        this.reduce();
        int result = this._numerator.hashCode();
        result = 31 * result + this._denominator.hashCode();
        return result;
    }

    public String toFractionString() {
        if (!this._reduced) {
            return this.reduce().toFractionString();
        }
        return this._numerator + "/" + this._denominator;
    }

    public String toMixedString() {
        if (!this._reduced) {
            return this.reduce().toMixedString();
        }
        if (this._denominator.equals(BigInteger.ONE)) {
            return this._numerator.toString();
        }
        BigInteger whole = this.wholePart();
        if (whole.signum() == 0) {
            return this.fractionPart().toFractionString();
        }
        return whole + " " + this.fractionPart().abs().toFractionString();
    }

    public String toDecimalString() {
        return this.toBigDecimal().toString();
    }

    public String toPlainDecimalString() {
        return this.toBigDecimal().toPlainString();
    }

    public String toEngineeringString() {
        return this.toBigDecimal().toEngineeringString();
    }

    public String toString() {
        return this._numerator + " / " + this._denominator;
    }

    private Object writeReplace() {
        return new Serializer(this);
    }

    private static class Serializer
    implements Externalizable {
        private Rational _rational;

        public Serializer() {
        }

        public Serializer(Rational rational) {
            this._rational = rational;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeObject(this._rational._numerator);
            out.writeObject(this._rational._denominator);
            out.writeBoolean(this._rational._reduced);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    BigInteger numerator = (BigInteger)in.readObject();
                    BigInteger denominator = (BigInteger)in.readObject();
                    boolean reduced = in.readBoolean();
                    this._rational = Rational.get(numerator, denominator, reduced);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported version: " + version);
                }
            }
        }

        Object readResolve() {
            return this._rational;
        }
    }
}

