/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractProductUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Momentum;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class MomentumUnit
extends AbstractProductUnit<MassUnit, VelocityUnit, Momentum, MomentumUnit> {
    private static final UnitCache<MomentumUnit> CACHE = new UnitCache();
    public static final MomentumUnit BASE = MomentumUnit.get(MassUnit.BASE, VelocityUnit.BASE, CoercionConstants.r.postfixBind(1), "newton-second", "N\u22c5s");

    public static MomentumUnit get(MassUnit massUnit, VelocityUnit velocityUnit) {
        return MomentumUnit.get(massUnit, velocityUnit, null, null, null);
    }

    public static MomentumUnit get(MassUnit massUnit, VelocityUnit velocityUnit, Rational factor, String name, String symbol) {
        MomentumUnit unit = new MomentumUnit(massUnit, velocityUnit, factor, name, symbol);
        return (MomentumUnit)CACHE.get(unit);
    }

    private MomentumUnit(MassUnit massUnit, VelocityUnit velocityUnit, Rational factor, String name, String symbol) {
        super(massUnit, velocityUnit, factor, name, symbol);
    }

    @Override
    public Momentum makeDimension(Number amount) {
        return new Momentum(Rational.get(amount), this);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public VelocityUnit getVelocityUnit() {
        return (VelocityUnit)this.getRightUnit();
    }

    public EnergyUnit times(VelocityUnit v) {
        return EnergyUnit.get(this.getMassUnit().times(this.getVelocityUnit().div(v.getTimeUnit())), v.getLengthUnit());
    }

    @Override
    public MassUnit div(VelocityUnit w) {
        return this.getMassUnit();
    }

    @Override
    public ForceUnit div(TimeUnit t) {
        return ForceUnit.get(this.getMassUnit(), this.getVelocityUnit().div(t));
    }
}

