/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractProductUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.Force;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class ForceUnit
extends AbstractProductUnit<MassUnit, AccelerationUnit, Force, ForceUnit> {
    private static final UnitCache<ForceUnit> CACHE = new UnitCache();
    public static final ForceUnit N;
    public static final ForceUnit BASE;

    public static ForceUnit get(MassUnit massUnit, AccelerationUnit accUnit) {
        return ForceUnit.get(massUnit, accUnit, null, null, null);
    }

    public static ForceUnit get(MassUnit massUnit, AccelerationUnit accUnit, Rational factor, String name, String symbol) {
        ForceUnit unit = new ForceUnit(massUnit, accUnit, factor, name, symbol);
        return (ForceUnit)CACHE.get(unit);
    }

    private ForceUnit(MassUnit massUnit, AccelerationUnit accUnit, Rational factor, String name, String symbol) {
        super(massUnit, accUnit, factor, name, symbol);
    }

    @Override
    public Force makeDimension(Number amount) {
        return new Force(Rational.get(amount), this);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public AccelerationUnit getAccUnit() {
        return (AccelerationUnit)this.getRightUnit();
    }

    public PowerUnit times(VelocityUnit v) {
        return PowerUnit.get(this.times(v.getLengthUnit()), v.getTimeUnit());
    }

    public EnergyUnit times(LengthUnit len) {
        return EnergyUnit.get(this, len);
    }

    public MomentumUnit times(TimeUnit t) {
        return MomentumUnit.get(this.getMassUnit(), VelocityUnit.get(this.getAccUnit().getVelocityUnit().getLengthUnit(), t));
    }

    @Override
    public MassUnit div(AccelerationUnit acc) {
        return this.getMassUnit();
    }

    static {
        BASE = N = ForceUnit.get(MassUnit.Kilogram, AccelerationUnit.BASE, CoercionConstants.r.postfixBind(1), "Newton", "N");
    }
}

