/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.api;

import java.util.Objects;
import manifold.collections.api.range.Sequential;
import manifold.ext.api.ComparableUsing;
import manifold.science.api.Dimension;
import manifold.science.api.Unit;
import manifold.science.util.Rational;

public abstract class AbstractMeasure<U extends Unit<T, U>, T extends AbstractMeasure<U, T>>
implements Dimension<T>,
Sequential<T, Rational, U> {
    private final Rational _value;
    private final U _displayUnit;

    public AbstractMeasure(Rational value, U unit, U displayUnit) {
        this._displayUnit = displayUnit;
        this._value = unit.toBaseUnits(value);
    }

    public abstract U getBaseUnit();

    public abstract T make(Rational var1, U var2, U var3);

    public abstract T make(Rational var1, U var2);

    public T copy(U dsiplayUnit) {
        return this.make(this._value, this.getBaseUnit(), dsiplayUnit);
    }

    @Override
    public T copy(Rational value) {
        return this.make(value, this.getBaseUnit(), this.getDisplayUnit());
    }

    public Rational getValue() {
        return this._value;
    }

    public U getDisplayUnit() {
        return this._displayUnit;
    }

    @Override
    public T fromNumber(Rational p0) {
        return this.make(p0, this._displayUnit);
    }

    public T fromBaseNumber(Rational p0) {
        return this.make(p0, this.getBaseUnit(), this._displayUnit);
    }

    @Override
    public Rational toNumber() {
        return this.toNumber(this._displayUnit);
    }

    @Override
    public Rational toBaseNumber() {
        return this._value;
    }

    public T to(U displayUnit) {
        return this.copy(displayUnit);
    }

    public Rational toNumber(U unit) {
        return unit.from((AbstractMeasure)this);
    }

    public String toString() {
        return this.toNumber().toBigDecimal().stripTrailingZeros().toPlainString() + " " + this.getDisplayUnit().getSymbol();
    }

    public String toMixedString() {
        return this.toNumber().toMixedString() + " " + this.getDisplayUnit().getSymbol();
    }

    public int hashCode() {
        return Objects.hash(this._value, this._displayUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMeasure that = (AbstractMeasure)o;
        return this._value.equals(that._value) && this._displayUnit.equals(that._displayUnit);
    }

    public ComparableUsing.EqualityMode equalityMode() {
        return ComparableUsing.EqualityMode.CompareTo;
    }

    public int compareTo(T that) {
        return this._value.compareTo(((AbstractMeasure)that)._value);
    }

    public T nextInSequence(Rational step, U unit) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? Rational.ONE : step;
        unit = unit == null || unit != null && null != null && unit.compareToUsing(null, ComparableUsing.Operator.EQ) ? this.getDisplayUnit() : unit;
        return this.fromBaseNumber(this.toBaseNumber().plus(unit.toBaseUnits(step).minus(unit.toBaseUnits(Rational.ZERO))));
    }

    public T nextNthInSequence(Rational step, U unit, int index) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? Rational.ONE : step;
        unit = unit == null || unit != null && null != null && unit.compareToUsing(null, ComparableUsing.Operator.EQ) ? this.getDisplayUnit() : unit;
        return this.fromBaseNumber(this.toNumber().plus(unit.toBaseUnits(step).minus(unit.toBaseUnits(Rational.ZERO)).times(index)));
    }

    public T previousInSequence(Rational step, U unit) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? Rational.ONE : step;
        unit = unit == null || unit != null && null != null && unit.compareToUsing(null, ComparableUsing.Operator.EQ) ? this.getDisplayUnit() : unit;
        return this.fromBaseNumber(this.toNumber().minus(unit.toBaseUnits(step).minus(unit.toBaseUnits(Rational.ZERO))));
    }

    public T previousNthInSequence(Rational step, U unit, int index) {
        step = step == null || step != null && null != null && step.compareToUsing(null, ComparableUsing.Operator.EQ) ? Rational.ONE : step;
        unit = unit == null || unit != null && null != null && unit.compareToUsing(null, ComparableUsing.Operator.EQ) ? this.getDisplayUnit() : unit;
        return this.fromBaseNumber(this.toNumber().minus(unit.toBaseUnits(step).minus(unit.toBaseUnits(Rational.ZERO)).times(index)));
    }

    @Override
    public T plus(T operand) {
        return (T)this.copy(this.toBaseNumber().plus(((AbstractMeasure)operand).toBaseNumber()));
    }

    @Override
    public T minus(T operand) {
        return (T)this.copy(this.toBaseNumber().minus(((AbstractMeasure)operand).toBaseNumber()));
    }

    @Override
    public Rational div(T operand) {
        return this.toBaseNumber().div(((AbstractMeasure)operand).toBaseNumber());
    }

    @Override
    public Rational rem(T operand) {
        return this.toBaseNumber().rem(((AbstractMeasure)operand).toBaseNumber());
    }
}

