/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.api;

import manifold.ext.api.ComparableUsing;
import manifold.science.api.Dimension;
import manifold.science.api.Unit;
import manifold.science.util.Rational;

public abstract class AbstractBinaryUnit<A extends Unit, B extends Unit, D extends Dimension<D>, U extends AbstractBinaryUnit<A, B, D, U>>
implements Unit<D, U> {
    private final A _leftUnit;
    private final B _rightUnit;
    private final Rational _factor;
    private final String _name;
    private final String _symbol;

    protected AbstractBinaryUnit(A leftUnit, B rightUnit) {
        this(leftUnit, rightUnit, null, null, null);
    }

    protected AbstractBinaryUnit(A leftUnit, B rightUnit, Rational factor) {
        this(leftUnit, rightUnit, factor, null, null);
    }

    protected AbstractBinaryUnit(A leftUnit, B rightUnit, Rational factor, String name) {
        this(leftUnit, rightUnit, factor, name, null);
    }

    protected AbstractBinaryUnit(A leftUnit, B rightUnit, Rational factor, String name, String symbol) {
        this._leftUnit = leftUnit;
        this._rightUnit = rightUnit;
        this._factor = factor == null || factor != null && null != null && factor.compareToUsing(null, ComparableUsing.Operator.EQ) ? Rational.ONE : factor;
        this._name = name;
        this._symbol = symbol;
    }

    protected A getLeftUnit() {
        return this._leftUnit;
    }

    protected B getRightUnit() {
        return this._rightUnit;
    }

    public Rational getFactor() {
        return this._factor;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getSymbol() {
        return this._symbol;
    }

    @Override
    public Rational from(D r) {
        return r.toBaseNumber().div(this.toBaseUnits(Rational.ONE));
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return 31 * (31 * this._leftUnit.hashCode() + this._rightUnit.hashCode()) + this._factor.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractBinaryUnit that = (AbstractBinaryUnit)obj;
        Object object = that.getLeftUnit();
        return (this._leftUnit == object ? true : (this._leftUnit == null || object == null ? false : this._leftUnit.compareToUsing(object, ComparableUsing.Operator.EQ))) && (this._rightUnit == (object = that.getRightUnit()) ? true : (this._rightUnit == null || object == null ? false : this._rightUnit.compareToUsing(object, ComparableUsing.Operator.EQ))) && (this._factor == (object = that._factor) ? true : (this._factor == null || object == null ? false : this._factor.compareToUsing(object, ComparableUsing.Operator.EQ)));
    }
}

