/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractProductUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.Energy;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.HeatCapacityUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MagneticFluxUnit;
import manifold.science.measures.MetricScaleUnit;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.TemperatureUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class EnergyUnit
extends AbstractProductUnit<ForceUnit, LengthUnit, Energy, EnergyUnit> {
    private static final UnitCache<EnergyUnit> CACHE = new UnitCache();
    public static EnergyUnit J = EnergyUnit.get(ForceUnit.BASE, LengthUnit.BASE, null, "Joule", "J");
    public static EnergyUnit kJ = EnergyUnit.get(ForceUnit.BASE, LengthUnit.BASE, MetricScaleUnit.k.postfixBind(1), "Kilojoule", "kJ");
    public static EnergyUnit cal = EnergyUnit.get(ForceUnit.BASE, LengthUnit.BASE, CoercionConstants.r.postfixBind("4.184"), "Calorie", "cal");
    public static EnergyUnit kcal = EnergyUnit.get(ForceUnit.BASE, LengthUnit.BASE, CoercionConstants.r.postfixBind("4184"), "Kilocalorie", "kcal");
    public static EnergyUnit eV = EnergyUnit.get(ForceUnit.BASE, LengthUnit.BASE, CoercionConstants.r.postfixBind("1.60217733e-19"), "Electronvolt", "eV");
    public static EnergyUnit BASE = J;

    public static EnergyUnit get(ForceUnit forceUnit, LengthUnit lengthUnit) {
        return EnergyUnit.get(forceUnit, lengthUnit, null, null, null);
    }

    public static EnergyUnit get(ForceUnit forceUnit, LengthUnit lengthUnit, Rational factor, String name, String symbol) {
        EnergyUnit unit = new EnergyUnit(forceUnit, lengthUnit, factor, name, symbol);
        return (EnergyUnit)CACHE.get(unit);
    }

    private EnergyUnit(ForceUnit forceUnit, LengthUnit lengthUnit, Rational factor, String name, String symbol) {
        super(forceUnit, lengthUnit, factor, name, symbol);
    }

    @Override
    public Energy makeDimension(Number amount) {
        return new Energy(Rational.get(amount), this);
    }

    public ForceUnit getForceUnit() {
        return (ForceUnit)this.getLeftUnit();
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getRightUnit();
    }

    @Override
    public ForceUnit div(LengthUnit w) {
        return this.getForceUnit();
    }

    @Override
    public PowerUnit div(TimeUnit time) {
        return PowerUnit.get(this, time);
    }

    @Override
    public TimeUnit div(PowerUnit power) {
        return power.getTimeUnit();
    }

    @Override
    public HeatCapacityUnit div(TemperatureUnit temperature) {
        return HeatCapacityUnit.get(this, temperature);
    }

    @Override
    public TemperatureUnit div(HeatCapacityUnit c) {
        return c.getTemperatureUnit();
    }

    @Override
    public MagneticFluxUnit div(CurrentUnit i) {
        return MagneticFluxUnit.get(this, i);
    }

    @Override
    public CurrentUnit div(MagneticFluxUnit mf) {
        return mf.getCurrentUnit();
    }
}

