/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractPrimaryUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Length;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.MetricFactorConstants;
import manifold.science.util.Rational;

public final class LengthUnit
extends AbstractPrimaryUnit<Length, LengthUnit> {
    private static final UnitCache<LengthUnit> CACHE = new UnitCache();
    public static final LengthUnit Femto = LengthUnit.get(MetricFactorConstants.FEMTO, "Femtometer", "fm");
    public static final LengthUnit Pico = LengthUnit.get(MetricFactorConstants.PICO, "Picometer", "pm");
    public static final LengthUnit Angstrom = LengthUnit.get(CoercionConstants.r.postfixBind("1e-10"), "Angstrom", "\u00c5");
    public static final LengthUnit Nano = LengthUnit.get(MetricFactorConstants.NANO, "Nanometer", "nm");
    public static final LengthUnit Micro = LengthUnit.get(MetricFactorConstants.MICRO, "Micrometre", "\u00b5m");
    public static final LengthUnit Milli = LengthUnit.get(MetricFactorConstants.MILLI, "Millimeter", "mm");
    public static final LengthUnit Centi = LengthUnit.get(MetricFactorConstants.CENTI, "Centimeter", "cm");
    public static final LengthUnit Deci = LengthUnit.get(MetricFactorConstants.DECI, "Decimeter", "dm");
    public static final LengthUnit Meter = LengthUnit.get(CoercionConstants.r.postfixBind(1), "Meter", "m");
    public static final LengthUnit Kilometer = LengthUnit.get(MetricFactorConstants.KILO, "Kilometer", "km");
    public static final LengthUnit Megameter = LengthUnit.get(MetricFactorConstants.KILO.pow(2), "Megameter", "Mm");
    public static final LengthUnit Gigameter = LengthUnit.get(MetricFactorConstants.KILO.pow(3), "Gigameter", "Gm");
    public static final LengthUnit Terameter = LengthUnit.get(MetricFactorConstants.KILO.pow(4), "Terameter", "Tm");
    public static final LengthUnit Caliber = LengthUnit.get(CoercionConstants.r.postfixBind("0.000254"), "Caliber", "cal.");
    public static final LengthUnit Inch = LengthUnit.get(CoercionConstants.r.postfixBind("0.0254"), "Inch", "in");
    public static final LengthUnit Foot = LengthUnit.get(CoercionConstants.r.postfixBind("0.0254").times(12), "Foot", "ft");
    public static final LengthUnit Yard = LengthUnit.get(CoercionConstants.r.postfixBind("0.0254").times(12).times(3), "Yard", "yd");
    public static final LengthUnit Rod = LengthUnit.get(CoercionConstants.r.postfixBind("5.0292"), "Rod", "rd");
    public static final LengthUnit Chain = LengthUnit.get(CoercionConstants.r.postfixBind("20.1168"), "Chain", "ch");
    public static final LengthUnit Furlong = LengthUnit.get(CoercionConstants.r.postfixBind("201.168"), "Furlong", "fur");
    public static final LengthUnit Mile = LengthUnit.get(CoercionConstants.r.postfixBind("1609.344"), "Mile", "mi");
    public static final LengthUnit NauticalMile = LengthUnit.get(CoercionConstants.r.postfixBind(1852), "NauticalMile", "n.m.");
    public static final LengthUnit IAU = LengthUnit.get(CoercionConstants.r.postfixBind("1.49597870e11"), "IAU-length", "au");
    public static final LengthUnit LightYear = LengthUnit.get(CoercionConstants.r.postfixBind("9.460730473e+15"), "LightYear", "ly");
    public static final LengthUnit Planck = LengthUnit.get(CoercionConstants.r.postfixBind("1.61605e-35"), "Planck-length", "\u2113P");
    public static final LengthUnit Cubit = LengthUnit.get(CoercionConstants.r.postfixBind("0.4572"), "Cubit", "cbt");
    public static final LengthUnit BASE = Meter;

    public static LengthUnit get(Rational meterFactor, String name, String symbol) {
        return (LengthUnit)CACHE.get(new LengthUnit(meterFactor, name, symbol));
    }

    private LengthUnit(Rational meters, String name, String symbol) {
        super(meters, name, symbol);
    }

    public Rational getMeters() {
        return this.toNumber();
    }

    @Override
    public Length makeDimension(Number amount) {
        return new Length(Rational.get(amount), this);
    }

    public EnergyUnit postfixBind(ForceUnit f) {
        return this.times(f);
    }

    public VelocityUnit div(TimeUnit t) {
        return VelocityUnit.get(this, t);
    }

    public TimeUnit div(VelocityUnit v) {
        return v.getTimeUnit();
    }

    public AreaUnit times(LengthUnit len) {
        return AreaUnit.get(this, len);
    }

    public VolumeUnit times(AreaUnit area) {
        return VolumeUnit.get(this, area);
    }

    public EnergyUnit times(ForceUnit f) {
        return EnergyUnit.get(f, this);
    }
}

