/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.extensions.java.time.LocalDate;

import java.time.LocalDate;
import java.time.Period;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.util.Rational;

@Extension
public class ManLocalDateExt {
    public static LocalDate plus(@This LocalDate thiz, Time time) {
        if (((TimeUnit)time.getDisplayUnit()).isDateBased()) {
            Rational years = time.toBaseNumber().div(TimeUnit.Year.getSeconds());
            int wholeYears = years.wholePart().intValue();
            Rational months = years.fractionPart().times(TimeUnit.Year.getSeconds()).div(TimeUnit.Month.getSeconds());
            int wholeMonths = months.wholePart().intValue();
            Rational days = months.fractionPart().times(TimeUnit.Month.getSeconds()).div(TimeUnit.Day.getSeconds());
            int wholeDays = days.wholePart().intValue();
            Period period = Period.of(wholeYears, wholeMonths, wholeDays);
            return thiz.plus(period);
        }
        return thiz.plus(time);
    }

    public static LocalDate minus(@This LocalDate thiz, Time time) {
        if (((TimeUnit)time.getDisplayUnit()).isDateBased()) {
            Rational years = time.toBaseNumber().div(TimeUnit.Year.getSeconds());
            int wholeYears = years.wholePart().intValue();
            Rational months = years.fractionPart().times(TimeUnit.Year.getSeconds()).div(TimeUnit.Month.getSeconds());
            int wholeMonths = months.wholePart().intValue();
            Rational days = months.fractionPart().times(TimeUnit.Month.getSeconds()).div(TimeUnit.Day.getSeconds());
            int wholeDays = days.wholePart().intValue();
            Period period = Period.of(wholeYears, wholeMonths, wholeDays);
            return thiz.minus(period);
        }
        return thiz.minus(time);
    }
}

