/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.api;

import java.util.Objects;
import manifold.science.api.Dimension;
import manifold.science.api.Unit;
import manifold.science.util.Rational;

public abstract class AbstractPrimaryUnit<D extends Dimension<D>, U extends Unit<D, U>>
implements Unit<D, U> {
    private final Rational _baseFactor;
    private final String _name;
    private final String _symbol;

    protected AbstractPrimaryUnit(Rational baseFactor, String name, String symbol) {
        this._baseFactor = baseFactor;
        this._name = name;
        this._symbol = symbol;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getSymbol() {
        return this._symbol;
    }

    @Override
    public Rational toBaseUnits(Rational theseUnits) {
        return this._baseFactor.times(theseUnits);
    }

    @Override
    public Rational from(D dim) {
        return dim.toBaseNumber().div(this._baseFactor);
    }

    @Override
    public final Rational toNumber() {
        return this._baseFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPrimaryUnit)) {
            return false;
        }
        AbstractPrimaryUnit that = (AbstractPrimaryUnit)o;
        return this._baseFactor.equals(that._baseFactor);
    }

    public int hashCode() {
        return Objects.hash(this._baseFactor);
    }
}

