/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Capacitance;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.PotentialUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class CapacitanceUnit
extends AbstractQuotientUnit<ChargeUnit, PotentialUnit, Capacitance, CapacitanceUnit> {
    private static final UnitCache<CapacitanceUnit> CACHE = new UnitCache();
    public static final CapacitanceUnit F;
    public static final CapacitanceUnit BASE;

    public static CapacitanceUnit get(ChargeUnit chargeUnit, PotentialUnit potentialUnit) {
        return CapacitanceUnit.get(chargeUnit, potentialUnit, null, null, null);
    }

    public static CapacitanceUnit get(ChargeUnit chargeUnit, PotentialUnit potentialUnit, Rational factor, String name, String symbol) {
        CapacitanceUnit unit = new CapacitanceUnit(chargeUnit, potentialUnit, factor, name, symbol);
        return (CapacitanceUnit)CACHE.get(unit);
    }

    private CapacitanceUnit(ChargeUnit chargeUnit, PotentialUnit potentialUnit, Rational factor, String name, String symbol) {
        super(chargeUnit, potentialUnit, factor, name, symbol);
    }

    @Override
    public Capacitance makeDimension(Number amount) {
        return new Capacitance(Rational.get(amount), this);
    }

    public ChargeUnit getChargeUnit() {
        return (ChargeUnit)this.getLeftUnit();
    }

    public PotentialUnit getPotentialUnit() {
        return (PotentialUnit)this.getRightUnit();
    }

    static {
        BASE = F = CapacitanceUnit.get(ChargeUnit.BASE, PotentialUnit.BASE, CoercionConstants.r.postfixBind(1), "Farad", "F");
    }
}

