/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractPrimaryUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.StorageCapacity;
import manifold.science.util.CoercionConstants;
import manifold.science.util.MetricFactorConstants;
import manifold.science.util.Rational;

public final class StorageCapacityUnit
extends AbstractPrimaryUnit<StorageCapacity, StorageCapacityUnit> {
    private static final UnitCache<StorageCapacityUnit> CACHE = new UnitCache();
    public static final StorageCapacityUnit Bit = StorageCapacityUnit.get(CoercionConstants.r.postfixBind(1).div(8), "Bit", "bit");
    public static final StorageCapacityUnit Nibble = StorageCapacityUnit.get(Rational.HALF, "Nibble", "nibble");
    public static final StorageCapacityUnit Byte = StorageCapacityUnit.get(Rational.ONE, "Byte", "B");
    public static final StorageCapacityUnit KB = StorageCapacityUnit.get(MetricFactorConstants.KILO, "Kilobyte", "KB");
    public static final StorageCapacityUnit KiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI, "Kibibyte", "KiB");
    public static final StorageCapacityUnit MB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(2), "Megabyte", "MB");
    public static final StorageCapacityUnit MiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(2), "Mebibyte", "MiB");
    public static final StorageCapacityUnit GB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(3), "Gigabyte", "GB");
    public static final StorageCapacityUnit GiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(3), "Gibibyte", "GiB");
    public static final StorageCapacityUnit TB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(4), "Terabyte", "TB");
    public static final StorageCapacityUnit TiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(4), "Tebibyte", "TiB");
    public static final StorageCapacityUnit PB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(5), "Petabyte", "TB");
    public static final StorageCapacityUnit PiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(5), "Pebibyte", "TiB");
    public static final StorageCapacityUnit EB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(6), "Exabyte", "EB");
    public static final StorageCapacityUnit EiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(6), "Exbibyte", "EiB");
    public static final StorageCapacityUnit ZB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(7), "Zettabyte", "ZB");
    public static final StorageCapacityUnit ZiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(7), "Zebibyte", "ZiB");
    public static final StorageCapacityUnit YB = StorageCapacityUnit.get(MetricFactorConstants.KILO.pow(8), "Yottabyte", "YB");
    public static final StorageCapacityUnit YiB = StorageCapacityUnit.get(MetricFactorConstants.KIBI.pow(8), "Yobibyte", "YiB");
    public static final StorageCapacityUnit BASE = Byte;

    public static StorageCapacityUnit get(Rational bytes, String name, String symbol) {
        return (StorageCapacityUnit)CACHE.get(new StorageCapacityUnit(bytes, name, symbol));
    }

    private StorageCapacityUnit(Rational bytes, String name, String symbol) {
        super(bytes, name, symbol);
    }

    @Override
    public StorageCapacity makeDimension(Number amount) {
        return new StorageCapacity(Rational.get(amount), this);
    }
}

