/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.MagneticFluxDensity;
import manifold.science.measures.MagneticFluxUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class MagneticFluxDensityUnit
extends AbstractQuotientUnit<MagneticFluxUnit, AreaUnit, MagneticFluxDensity, MagneticFluxDensityUnit> {
    private static final UnitCache<MagneticFluxDensityUnit> CACHE = new UnitCache();
    public static final MagneticFluxDensityUnit T;
    public static final MagneticFluxDensityUnit BASE;

    public static MagneticFluxDensityUnit get(MagneticFluxUnit magneticfluxUnit, AreaUnit areaUnit) {
        return MagneticFluxDensityUnit.get(magneticfluxUnit, areaUnit, null, null, null);
    }

    public static MagneticFluxDensityUnit get(MagneticFluxUnit magneticfluxUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        MagneticFluxDensityUnit unit = new MagneticFluxDensityUnit(magneticfluxUnit, areaUnit, factor, name, symbol);
        return (MagneticFluxDensityUnit)CACHE.get(unit);
    }

    private MagneticFluxDensityUnit(MagneticFluxUnit magneticfluxUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        super(magneticfluxUnit, areaUnit, factor, name, symbol);
    }

    @Override
    public MagneticFluxDensity makeDimension(Number amount) {
        return new MagneticFluxDensity(Rational.get(amount), this);
    }

    public MagneticFluxUnit getMagneticFluxUnit() {
        return (MagneticFluxUnit)this.getLeftUnit();
    }

    public AreaUnit getAreaUnit() {
        return (AreaUnit)this.getRightUnit();
    }

    static {
        BASE = T = MagneticFluxDensityUnit.get(MagneticFluxUnit.BASE, AreaUnit.BASE, CoercionConstants.r.postfixBind(1), "Tesla", "T");
    }
}

