/*
 * Copyright (c) 2019 - Manifold Systems LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package manifold.science.util;

import manifold.science.measures.Angle;

import static manifold.science.util.UnitConstants.deg;

public interface AngleConstants
{
  //
  // Compass
  //
  Angle N = 0 deg;
  Angle North = N;
  Angle NbE = 11.25 deg;
  Angle NNE = 22.50 deg;
  Angle NEbN = 33.75 deg;
  Angle NE = 45 deg;
  Angle NEbE = 56.25 deg;
  Angle ENE = 67.50 deg;
  Angle EbN = 78.75 deg;
  Angle E = 90 deg;
  Angle East = E;
  Angle EbS = 101.25 deg;
  Angle ESE = 112.50 deg;
  Angle SEbE = 123.75 deg;
  Angle SE = 135 deg;
  Angle SEbS = 146.25 deg;
  Angle SSE = 157.50 deg;
  Angle SbE = 168.75 deg;
  Angle S = 180 deg;
  Angle South = S;
  Angle SbW = 191.25 deg;
  Angle SSW = 202.50 deg;
  Angle SWbS = 213.75 deg;
  Angle SW = 225 deg;
  Angle SWbW = 236.25 deg;
  Angle WSW = 247.50 deg;
  Angle WbS = 258.75 deg;
  Angle W = 270 deg;
  Angle West = W;
  Angle WbN = 281.25 deg;
  Angle WNW = 292.50 deg;
  Angle NWbW = 303.75 deg;
  Angle NW = 315 deg;
  Angle NWbN = 326.25 deg;
  Angle NNW = 337.50 deg;
  Angle NbW = 348.75 deg;
}