/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.vector;

import manifold.ext.api.ComparableUsing;
import manifold.science.api.AbstractMeasure;
import manifold.science.api.Dimension;
import manifold.science.api.Unit;
import manifold.science.measures.Angle;
import manifold.science.measures.AngleUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.DimensionlessConstants;
import manifold.science.util.Rational;

public abstract class Vector<M extends AbstractMeasure<U, M>, U extends Unit<M, U>, V extends Vector<M, U, V>>
implements Dimension<V> {
    private final M _magnitude;
    private final Angle _angle;

    protected Vector(M magnitude, Angle angle) {
        this._magnitude = magnitude;
        this._angle = angle;
    }

    public abstract V make(M var1, Angle var2);

    public M getMagnitude() {
        return this._magnitude;
    }

    public Angle getAngle() {
        return this._angle;
    }

    public M getX() {
        return (M)((AbstractMeasure)this._magnitude).fromBaseNumber(((AbstractMeasure)this._magnitude).toBaseNumber().times(Math.cos(((Angle)this._angle.to(AngleUnit.Radian)).getValue().doubleValue())));
    }

    public M getY() {
        return (M)((AbstractMeasure)this._magnitude).fromBaseNumber(((AbstractMeasure)this._magnitude).toBaseNumber().times(Math.sin(((Angle)this._angle.to(AngleUnit.Radian)).getValue().doubleValue())));
    }

    @Override
    public V unaryMinus() {
        return this.make(this._magnitude, (Angle)this._angle.plus((AbstractMeasure)AngleUnit.Degree.postfixBind(180)));
    }

    @Override
    public V plus(V v) {
        Rational x = ((AbstractMeasure)this.getX()).toBaseNumber().plus(((AbstractMeasure)((Vector)v).getX()).toBaseNumber());
        Rational y = ((AbstractMeasure)this.getY()).toBaseNumber().plus(((AbstractMeasure)((Vector)v).getY()).toBaseNumber());
        Rational rational = CoercionConstants.r.postfixBind(0);
        Rational angle = (x == rational ? true : (x == null || rational == null ? false : x.compareToUsing(rational, ComparableUsing.Operator.EQ))) ? x : CoercionConstants.r.postfixBind(Math.atan(y.div(x).doubleValue()));
        Rational mag = x.times(x).plus(y.times(y)).sqrt();
        if (x.compareToUsing(CoercionConstants.r.postfixBind(0), ComparableUsing.Operator.LT)) {
            angle = y.compareToUsing(CoercionConstants.r.postfixBind(0), ComparableUsing.Operator.LT) ? angle.minus(DimensionlessConstants.pi) : angle.plus(DimensionlessConstants.pi);
        }
        return this.make(((AbstractMeasure)this._magnitude).fromBaseNumber(mag), new Angle(angle, AngleUnit.Radian, (AngleUnit)this._angle.getDisplayUnit()));
    }

    @Override
    public V minus(V v) {
        return (V)this.plus((V)((Vector)v).unaryMinus());
    }

    public Rational times(V v) {
        Rational x = ((AbstractMeasure)this.getX()).toBaseNumber().times(((AbstractMeasure)((Vector)v).getX()).toBaseNumber());
        Rational y = ((AbstractMeasure)this.getY()).toBaseNumber().times(((AbstractMeasure)((Vector)v).getY()).toBaseNumber());
        return x.plus(y);
    }

    @Override
    public Rational div(V v) {
        throw new UnsupportedOperationException();
    }

    public V copy(U lu, AngleUnit au) {
        return this.make(((AbstractMeasure)this._magnitude).make(((AbstractMeasure)this._magnitude).toBaseNumber(), ((AbstractMeasure)this._magnitude).getBaseUnit(), lu), new Angle(this._angle.toBaseNumber(), this._angle.getBaseUnit(), au));
    }

    @Override
    public V fromNumber(Rational p0) {
        return this.make(((AbstractMeasure)this._magnitude).make(p0, ((AbstractMeasure)this._magnitude).getDisplayUnit()), this._angle);
    }

    public V fromBaseNumber(Rational p0) {
        return this.make(((AbstractMeasure)this._magnitude).make(p0, ((AbstractMeasure)this._magnitude).getBaseUnit(), ((AbstractMeasure)this._magnitude).getDisplayUnit()), this._angle);
    }

    @Override
    public Rational toNumber() {
        return ((AbstractMeasure)this._magnitude).toNumber();
    }

    @Override
    public Rational toBaseNumber() {
        return ((AbstractMeasure)this._magnitude).toBaseNumber();
    }

    public V to(U lu, AngleUnit au) {
        return this.copy(lu, au);
    }

    public String toString() {
        return this._magnitude + " " + this._angle;
    }

    public int hashCode() {
        return 31 * ((AbstractMeasure)this._magnitude).hashCode() + this._angle.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Vector that = (Vector)o;
        Object object = that._magnitude;
        return (this._magnitude == object ? true : (this._magnitude == null || object == null ? false : this._magnitude.compareToUsing(object, ComparableUsing.Operator.EQ))) && (this._angle == (object = that._angle) ? true : (this._angle == null || object == null ? false : this._angle.compareToUsing(object, ComparableUsing.Operator.EQ)));
    }

    public int compareTo(V o) {
        return ((AbstractMeasure)this._magnitude).compareTo(((Vector)o).getMagnitude());
    }

    public ComparableUsing.EqualityMode equalityMode() {
        return ComparableUsing.EqualityMode.Equals;
    }
}

