/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Area;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.Density;
import manifold.science.measures.DensityUnit;
import manifold.science.measures.Length;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.Mass;
import manifold.science.measures.MassUnit;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.Rational;

public final class Volume
extends AbstractMeasure<VolumeUnit, Volume> {
    public Volume(Rational value, VolumeUnit unit, VolumeUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Volume(Rational value, VolumeUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public VolumeUnit getBaseUnit() {
        return VolumeUnit.BASE;
    }

    @Override
    public Volume make(Rational value, VolumeUnit unit, VolumeUnit displayUnit) {
        return new Volume(value, unit, displayUnit);
    }

    @Override
    public Volume make(Rational value, VolumeUnit unit) {
        return new Volume(value, unit);
    }

    public Area div(Length t) {
        return new Area(this.toBaseNumber().div(t.toBaseNumber()), AreaUnit.BASE, AreaUnit.get((LengthUnit)t.getDisplayUnit()));
    }

    public Length div(Area area) {
        return new Length(this.toBaseNumber().div(area.toBaseNumber()), LengthUnit.BASE, ((AreaUnit)area.getDisplayUnit()).getWidthUnit());
    }

    public Mass times(Density density) {
        return new Mass(this.toBaseNumber().times(density.toBaseNumber()), MassUnit.BASE, ((DensityUnit)density.getDisplayUnit()).getMassUnit());
    }
}

