/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.HeatCapacity;
import manifold.science.measures.TemperatureUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class HeatCapacityUnit
extends AbstractQuotientUnit<EnergyUnit, TemperatureUnit, HeatCapacity, HeatCapacityUnit> {
    private static final UnitCache<HeatCapacityUnit> CACHE = new UnitCache();
    public static final HeatCapacityUnit BASE = HeatCapacityUnit.get(EnergyUnit.BASE, TemperatureUnit.BASE);
    public static final HeatCapacityUnit kB = HeatCapacityUnit.get(EnergyUnit.BASE, TemperatureUnit.BASE, CoercionConstants.r.postfixBind("1.380649e-23"), "Boltzmann-constant", "kB");

    public static HeatCapacityUnit get(EnergyUnit energyUnit, TemperatureUnit temperatureUnit) {
        return HeatCapacityUnit.get(energyUnit, temperatureUnit, null, null, null);
    }

    public static HeatCapacityUnit get(EnergyUnit energyUnit, TemperatureUnit temperatureUnit, Rational factor, String name, String symbol) {
        HeatCapacityUnit unit = new HeatCapacityUnit(energyUnit, temperatureUnit, factor, name, symbol);
        return (HeatCapacityUnit)CACHE.get(unit);
    }

    private HeatCapacityUnit(EnergyUnit energyUnit, TemperatureUnit temperatureUnit, Rational factor, String name, String symbol) {
        super(energyUnit, temperatureUnit, factor, name, symbol);
    }

    @Override
    public HeatCapacity makeDimension(Number amount) {
        return new HeatCapacity(Rational.get(amount), this);
    }

    public EnergyUnit getEnergyUnit() {
        return (EnergyUnit)this.getLeftUnit();
    }

    public TemperatureUnit getTemperatureUnit() {
        return (TemperatureUnit)this.getRightUnit();
    }
}

