/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.Velocity;
import manifold.science.util.Rational;

public final class VelocityUnit
extends AbstractQuotientUnit<LengthUnit, TimeUnit, Velocity, VelocityUnit> {
    private static final UnitCache<VelocityUnit> CACHE = new UnitCache();
    public static final VelocityUnit BASE = VelocityUnit.get(LengthUnit.Meter, TimeUnit.Second);
    public static final VelocityUnit mph = VelocityUnit.get(LengthUnit.Mile, TimeUnit.Hour, Rational.ONE, "MPH", "mph");

    public static VelocityUnit get(LengthUnit lengthUnit, TimeUnit timeUnit) {
        return VelocityUnit.get(lengthUnit, timeUnit, null, null, null);
    }

    public static VelocityUnit get(LengthUnit lengthUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        VelocityUnit unit = new VelocityUnit(lengthUnit, timeUnit, factor, name, symbol);
        return (VelocityUnit)CACHE.get(unit);
    }

    private VelocityUnit(LengthUnit lengthUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super(lengthUnit, timeUnit, factor, name, symbol);
    }

    @Override
    public Velocity makeDimension(Number amount) {
        return new Velocity(Rational.get(amount), this);
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    public MomentumUnit postfixBind(MassUnit mass) {
        return this.times(mass);
    }

    public AccelerationUnit div(TimeUnit t) {
        return AccelerationUnit.get(this, t);
    }

    @Override
    public MomentumUnit times(MassUnit t) {
        return MomentumUnit.get(t, this);
    }

    @Override
    public PowerUnit times(ForceUnit force) {
        return force.times(this.getLengthUnit()).div(this.getTimeUnit());
    }
}

