/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.props;

import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import manifold.api.type.ContributorKind;
import manifold.api.type.ICompilerComponent;
import manifold.ext.ExtensionManifold;
import manifold.ext.ExtensionTransformer;
import manifold.ext.props.PropIssueMsg;
import manifold.ext.props.rt.api.PropOption;
import manifold.ext.props.rt.api.get;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.set;
import manifold.ext.props.rt.api.val;
import manifold.ext.props.rt.api.var;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.util.ManStringUtil;
import manifold.rt.api.util.Stack;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class PropertyProcessor
implements ICompilerComponent,
TaskListener {
    private TypeProcessor _tp;
    private BasicJavacTask _javacTask;
    private Stack<Pair<JCTree.JCClassDecl, ArrayList<JCTree>>> _propertyStatements;
    private Map<Symbol.ClassSymbol, Set<Symbol.VarSymbol>> _propMap;
    private Map<Symbol.ClassSymbol, Set<Symbol.VarSymbol>> _backingMap;
    private Map<Symbol.ClassSymbol, Set<Symbol.VarSymbol>> _nonbackingMap;
    private TaskEvent _taskEvent;
    private LocklessLazyVar<ExtensionTransformer> _extensionTransformer = LocklessLazyVar.make(() -> {
        ExtensionManifold extensionManifold = JavacPlugin.instance().getHost().getSingleModule().getTypeManifolds().stream().filter(e -> e instanceof ExtensionManifold).findFirst().orElse(null);
        return new ExtensionTransformer(extensionManifold, this._tp);
    });

    public void init(BasicJavacTask javacTask, TypeProcessor typeProcessor) {
        this._tp = typeProcessor;
        this._javacTask = javacTask;
        this._propertyStatements = new Stack();
        this._propMap = new HashMap<Symbol.ClassSymbol, Set<Symbol.VarSymbol>>();
        this._backingMap = new HashMap<Symbol.ClassSymbol, Set<Symbol.VarSymbol>>();
        this._nonbackingMap = new HashMap<Symbol.ClassSymbol, Set<Symbol.VarSymbol>>();
        javacTask.addTaskListener(this);
    }

    public void tailorCompiler() {
        this.replaceClassReaderCompleter();
    }

    private void replaceClassReaderCompleter() {
        ReflectUtil.LiveFieldRef thisCompleterField;
        if (JreUtil.isJava8()) {
            ClassReader classReader = ClassReader.instance(this._javacTask.getContext());
            thisCompleterField = ReflectUtil.field((Object)classReader, (String)"thisCompleter");
        } else {
            Object classFinder = ReflectUtil.method((String)"com.sun.tools.javac.code.ClassFinder", (String)"instance", (Class[])new Class[]{Context.class}).invokeStatic(new Object[]{this._javacTask.getContext()});
            thisCompleterField = ReflectUtil.field((Object)classFinder, (String)"thisCompleter");
        }
        Symbol.Completer thisCompleter = (Symbol.Completer)thisCompleterField.get();
        if (!(thisCompleter instanceof MyCompleter)) {
            MyCompleter myCompleter = new MyCompleter(thisCompleter);
            thisCompleterField.set((Object)myCompleter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ENTER && e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        this._taskEvent = e;
        try {
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl) || !this.shouldProcess(e.getCompilationUnit().getPackageName() + "." + ((JCTree.JCClassDecl)tree).name, e)) continue;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
                if (e.getKind() == TaskEvent.Kind.ENTER) {
                    classDecl.accept(new Enter_Start());
                    continue;
                }
                if (e.getKind() != TaskEvent.Kind.GENERATE) continue;
                new Generate_Start().handleClass(classDecl.sym);
            }
        }
        finally {
            this._taskEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ENTER && e.getKind() != TaskEvent.Kind.ANALYZE && e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        this._taskEvent = e;
        try {
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl) || !this.shouldProcess(e.getCompilationUnit().getPackageName() + "." + ((JCTree.JCClassDecl)tree).name, e)) continue;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
                if (e.getKind() == TaskEvent.Kind.ENTER) {
                    classDecl.accept(new Enter_Finish());
                    continue;
                }
                if (e.getKind() == TaskEvent.Kind.ANALYZE) {
                    classDecl.accept(new Analyze_Finish());
                    continue;
                }
                if (e.getKind() != TaskEvent.Kind.GENERATE) continue;
                new Generate_Finish().handleClass(classDecl.sym);
            }
        }
        finally {
            this._taskEvent = null;
        }
    }

    public boolean shouldProcess(String fqn, TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.ENTER) {
            JavacPlugin.instance().initialize(e);
        }
        return JavacPlugin.instance().getHost().getSingleModule().findTypeManifoldsFor(fqn).stream().map(ee -> ee.getContributorKind()).noneMatch(k -> k == ContributorKind.Supplemental);
    }

    private boolean isInterface(JCTree.JCClassDecl classDecl) {
        return classDecl.getKind() == Tree.Kind.INTERFACE;
    }

    private Symbol.MethodSymbol resolveGetMethod(Type type, Symbol field) {
        Types types = this._tp.getTypes();
        if (type instanceof Type.TypeVar) {
            type = types.erasure(type);
        }
        if (!(type.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Symbol.MethodSymbol method = ManAttr.getMethodSymbol((Types)types, (Type)type, (Type)field.type, (String)this.getGetterName(field, true), (Symbol.ClassSymbol)((Symbol.ClassSymbol)type.tsym), (int)0);
        if (method == null) {
            method = ManAttr.getMethodSymbol((Types)types, (Type)type, (Type)field.type, (String)this.getGetterName(field, false), (Symbol.ClassSymbol)((Symbol.ClassSymbol)type.tsym), (int)0);
        }
        return method;
    }

    private Symbol.MethodSymbol resolveSetMethod(Type type, Symbol field, Types types) {
        if (type instanceof Type.TypeVar) {
            type = types.erasure(type);
        }
        if (!(type.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        return ManAttr.getMethodSymbol((Types)types, (Type)type, (Type)field.type, (String)this.getSetterName(field.name), (Symbol.ClassSymbol)((Symbol.ClassSymbol)type.tsym), (int)1);
    }

    private boolean isAbstract(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField, List<JCTree.JCExpression> args) {
        if (this.isInterface(classDecl) && !this.isStatic(propField) && !this.isFinal(classDecl, propField)) {
            return true;
        }
        return Modifier.isAbstract((int)classDecl.getModifiers().flags) && this.hasOption(args, PropOption.Abstract);
    }

    private PropOption getAccess(JCTree.JCClassDecl classDecl, List<JCTree.JCExpression> args) {
        if (this.isInterface(classDecl)) {
            return PropOption.Public;
        }
        return this.hasOption(args, PropOption.Public) ? PropOption.Public : (this.hasOption(args, PropOption.Protected) ? PropOption.Protected : (this.hasOption(args, PropOption.Package) ? PropOption.Package : (this.hasOption(args, PropOption.Private) ? PropOption.Private : null)));
    }

    private boolean hasOption(List<JCTree.JCExpression> args, PropOption option) {
        if (args == null) {
            return false;
        }
        return args.stream().anyMatch(e -> this.isOption(option, (JCTree.JCExpression)e));
    }

    private boolean isOption(PropOption option, JCTree.JCExpression e) {
        if (e instanceof JCTree.JCLiteral) {
            return ((JCTree.JCLiteral)e).getValue() == option;
        }
        return e.toString().contains(option.name());
    }

    private JCTree.JCAnnotation getAnnotation(JCTree.JCVariableDecl tree, Class anno) {
        return tree.getModifiers().getAnnotations().stream().filter(e -> anno.getSimpleName().equals(e.annotationType.toString())).findFirst().orElse(null);
    }

    public boolean isPropertyField(Symbol sym) {
        return sym != null && !sym.isLocal() && (this.getAnnotationMirror(sym, var.class) != null || this.getAnnotationMirror(sym, val.class) != null || this.getAnnotationMirror(sym, get.class) != null || this.getAnnotationMirror(sym, set.class) != null);
    }

    public boolean isReadableProperty(Symbol sym) {
        return sym != null && (this.getAnnotationMirror(sym, var.class) != null || this.getAnnotationMirror(sym, val.class) != null || this.getAnnotationMirror(sym, get.class) != null);
    }

    public boolean isWritableProperty(Symbol sym) {
        return sym != null && !Modifier.isFinal((int)sym.flags_field) && (this.getAnnotationMirror(sym, var.class) != null || this.getAnnotationMirror(sym, set.class) != null);
    }

    private boolean isStatic(JCTree.JCVariableDecl propField) {
        long flags = propField.getModifiers().flags;
        return (flags & 8L) != 0L;
    }

    private boolean isFinal(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField) {
        boolean isInterface = this.isInterface(classDecl);
        long flags = propField.getModifiers().flags;
        return isInterface ? (flags & 0x10L) != 0L || (flags & 8L) != 0L && propField.init != null : (flags & 0x10L) != 0L;
    }

    private long getFlags(Attribute.Compound anno) {
        for (Symbol.MethodSymbol methSym : anno.getElementValues().keySet()) {
            if (!((Name)methSym.getSimpleName()).toString().equals("flags")) continue;
            return ((Number)anno.getElementValues().get(methSym).getValue()).longValue();
        }
        throw new IllegalStateException();
    }

    private Attribute.Compound getAnnotationMirror(Symbol sym, Class<? extends Annotation> annoClass) {
        for (Attribute.Compound anno : sym.getAnnotationMirrors()) {
            if (!annoClass.getTypeName().equals(anno.type.tsym.getQualifiedName().toString())) continue;
            return anno;
        }
        return null;
    }

    private boolean sameAccess(Symbol sym1, Symbol sym2) {
        return this.sameAccess((int)sym1.flags_field, (int)sym2.flags_field);
    }

    private boolean sameAccess(int flags1, int flags2) {
        return this.getAccess(flags1) == this.getAccess(flags2);
    }

    private int getAccess(Symbol sym) {
        return this.getAccess((int)sym.flags_field);
    }

    private int getAccess(int flags) {
        return flags & 7;
    }

    private void reportWarning(JCTree location, String message) {
        this.report(Diagnostic.Kind.WARNING, location, message);
    }

    private void reportError(JCTree location, String message) {
        this.report(Diagnostic.Kind.ERROR, location, message);
    }

    private void report(Diagnostic.Kind kind, JCTree location, String message) {
        this._tp.report(this._taskEvent.getSourceFile(), location, kind, message);
    }

    private String getGetterName(Symbol field, boolean isOk) {
        Symtab syms = Symtab.instance(this._javacTask.getContext());
        return (isOk && field.type == syms.booleanType ? "is" : "get") + ManStringUtil.capitalize((String)field.name.toString());
    }

    private String getGetterName(JCTree.JCVariableDecl tree, boolean isOk) {
        return (isOk && tree.vartype.toString().equals("boolean") ? "is" : "get") + ManStringUtil.capitalize((String)tree.name.toString());
    }

    private String getSetterName(Name name) {
        return "set" + ManStringUtil.capitalize((String)name.toString());
    }

    class Generate_Finish {
        Generate_Finish() {
        }

        public void handleClass(Symbol.ClassSymbol classSym) {
            Set nonbackingFields;
            IDynamicJdk.instance().getMembers(classSym, e -> e instanceof Symbol.ClassSymbol, false).forEach(c -> this.handleClass((Symbol.ClassSymbol)c));
            Set backingFields = (Set)PropertyProcessor.this._propMap.get(classSym);
            if (backingFields != null) {
                for (Symbol.VarSymbol varSym : backingFields) {
                    Attribute.Compound propgenAnno = PropertyProcessor.this.getAnnotationMirror(varSym, propgen.class);
                    if (propgenAnno == null) continue;
                    varSym.flags_field = varSym.flags_field & 0xFFFFFFFFFFFFFFFDL | PropertyProcessor.this.getFlags(propgenAnno);
                }
                PropertyProcessor.this._propMap.remove(classSym);
            }
            if ((nonbackingFields = (Set)PropertyProcessor.this._nonbackingMap.get(classSym)) != null) {
                for (Symbol.VarSymbol varSym : nonbackingFields) {
                    Type t = varSym.type;
                    Symbol.VarSymbol sym = new Symbol.VarSymbol(varSym.flags_field, varSym.name, t, classSym);
                    sym.appendAttributes((List<Attribute.Compound>)varSym.getAnnotationMirrors());
                    ReflectUtil.method((Object)ReflectUtil.field((Object)classSym, (String)"members_field").get(), (String)"enter", (Class[])new Class[]{Symbol.class}).invoke(new Object[]{sym});
                }
            }
            PropertyProcessor.this._nonbackingMap.remove(classSym);
        }
    }

    class Generate_Start {
        Generate_Start() {
        }

        private void handleClass(Symbol.ClassSymbol classSym) {
            IDynamicJdk.instance().getMembers(classSym, e -> e instanceof Symbol.ClassSymbol, false).forEach(c -> this.handleClass((Symbol.ClassSymbol)c));
            IDynamicJdk.instance().getMembers(classSym, e -> e instanceof Symbol.VarSymbol, false).forEach(varSym -> this.handleField(classSym, (Symbol.VarSymbol)varSym));
        }

        private void handleField(Symbol.ClassSymbol classSym, Symbol.VarSymbol fieldSym) {
            long modifiers = fieldSym.flags_field;
            if (!PropertyProcessor.this.isPropertyField(fieldSym)) {
                return;
            }
            Set backingSymbols = (Set)PropertyProcessor.this._backingMap.get(classSym);
            if (backingSymbols.contains(fieldSym)) {
                fieldSym.flags_field = fieldSym.flags_field & 0xFFFFFFFFFFFFFFFAL | 2L;
                if (fieldSym.getRawAttributes().stream().noneMatch(c -> c.getAnnotationType().toString().contains(propgen.class.getSimpleName()))) {
                    Names names = Names.instance(PropertyProcessor.this._javacTask.getContext());
                    Symtab symtab = Symtab.instance(PropertyProcessor.this._javacTask.getContext());
                    Symbol.ClassSymbol propgenSym = IDynamicJdk.instance().getTypeElement(PropertyProcessor.this._javacTask.getContext(), (Object)PropertyProcessor.this._tp.getCompilationUnit(), propgen.class.getTypeName());
                    Symbol.MethodSymbol nameMeth = (Symbol.MethodSymbol)IDynamicJdk.instance().getMembersByName(propgenSym, names.fromString("name")).iterator().next();
                    Symbol.MethodSymbol flagsMeth = (Symbol.MethodSymbol)IDynamicJdk.instance().getMembersByName(propgenSym, names.fromString("flags")).iterator().next();
                    Attribute.Compound propGenAnno = new Attribute.Compound(propgenSym.type, List.of(new Pair<Symbol.MethodSymbol, Attribute.Constant>(nameMeth, new Attribute.Constant(symtab.stringType, fieldSym.name.toString())), new Pair<Symbol.MethodSymbol, Attribute.Constant>(flagsMeth, new Attribute.Constant(symtab.longType, modifiers))));
                    fieldSym.appendAttributes(List.of(propGenAnno));
                    Set props = PropertyProcessor.this._propMap.computeIfAbsent(classSym, e -> new HashSet());
                    props.add(fieldSym);
                }
            } else {
                ReflectUtil.method((Object)ReflectUtil.method((Object)classSym, (String)"members", (Class[])new Class[0]).invoke(new Object[0]), (String)"remove", (Class[])new Class[]{Symbol.class}).invoke(new Object[]{fieldSym});
                Set nonbacking = PropertyProcessor.this._nonbackingMap.computeIfAbsent(classSym, e -> new HashSet());
                nonbacking.add(fieldSym);
            }
        }
    }

    class Analyze_Finish
    extends TreeTranslator {
        private Stack<JCTree.JCVariableDecl> _propDefs = new Stack();
        private Stack<JCTree.JCMethodDecl> _methodDefs = new Stack();
        private Stack<Pair<JCTree.JCClassDecl, Set<Symbol.VarSymbol>>> _backingSymbols = new Stack();

        Analyze_Finish() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            this._backingSymbols.push(new Pair(classDecl, new HashSet()));
            try {
                super.visitClassDef(classDecl);
                Set props = PropertyProcessor.this._backingMap.computeIfAbsent(classDecl.sym, e -> new HashSet());
                props.addAll((Collection)((Pair)this._backingSymbols.peek()).snd);
            }
            finally {
                this._backingSymbols.pop();
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            boolean isProp = PropertyProcessor.this.isPropertyField(tree.sym);
            if (isProp) {
                this._propDefs.push((Object)tree);
            }
            try {
                super.visitVarDef(tree);
            }
            finally {
                if (isProp) {
                    this._propDefs.pop();
                }
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            this._methodDefs.push((Object)tree);
            try {
                super.visitMethodDef(tree);
            }
            finally {
                this._methodDefs.pop();
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            Symbol.MethodSymbol getMethod;
            super.visitSelect(tree);
            if (!PropertyProcessor.this.isPropertyField(tree.sym)) {
                return;
            }
            Tree parent = PropertyProcessor.this._tp.getParent((Tree)tree);
            if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCUnary) {
                switch (((JCTree.JCUnary)parent).getTag()) {
                    case POSTDEC: 
                    case POSTINC: 
                    case PREDEC: 
                    case PREINC: {
                        return;
                    }
                }
            }
            Symbol.MethodSymbol methodSymbol = getMethod = PropertyProcessor.this.isReadableProperty(tree.sym) ? PropertyProcessor.this.resolveGetMethod(tree.selected.type, tree.sym) : null;
            if (getMethod != null) {
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)this._methodDefs.peek();
                if (methodDecl != null && methodDecl.sym == getMethod) {
                    ((Set)((Pair)this._backingSymbols.peek()).snd).add((Symbol.VarSymbol)tree.sym);
                    return;
                }
                if (!this.verifyAccess(tree, tree.sym, getMethod, "Read")) {
                    return;
                }
                TreeMaker make = PropertyProcessor.this._tp.getTreeMaker();
                JCTree.JCExpression receiver = tree.selected;
                JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), make.Select(receiver, getMethod), List.nil());
                methodCall = this.configMethod(tree, getMethod, methodCall);
                this.result = methodCall;
            } else {
                PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_ACCESS_WRITEONLY_PROPERTY.get(new Object[]{tree.sym.flatName()}));
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            Symbol.MethodSymbol getMethod;
            super.visitIdent(tree);
            if (!PropertyProcessor.this.isPropertyField(tree.sym)) {
                return;
            }
            Tree parent = PropertyProcessor.this._tp.getParent((Tree)tree);
            if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCUnary) {
                switch (((JCTree.JCUnary)parent).getTag()) {
                    case POSTDEC: 
                    case POSTINC: 
                    case PREDEC: 
                    case PREINC: {
                        return;
                    }
                }
            }
            Symbol.MethodSymbol methodSymbol = getMethod = PropertyProcessor.this.isReadableProperty(tree.sym) ? PropertyProcessor.this.resolveGetMethod(((JCTree.JCClassDecl)((Pair)this._backingSymbols.peek()).fst).type, tree.sym) : null;
            if (getMethod != null) {
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)this._methodDefs.peek();
                if (methodDecl != null && methodDecl.sym == getMethod) {
                    ((Set)((Pair)this._backingSymbols.peek()).snd).add((Symbol.VarSymbol)tree.sym);
                    if (((JCTree.JCMethodDecl)this._methodDefs.peek()).sym.isDefault()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_PROPERTY_IS_ABSTRACT.get(new Object[]{tree.sym.flatName()}));
                    }
                    return;
                }
                if (!this.verifyAccess(tree, tree.sym, getMethod, "Read")) {
                    return;
                }
                TreeMaker make = PropertyProcessor.this._tp.getTreeMaker();
                JCTree.JCExpression receiver = tree.sym.isStatic() ? make.Type(tree.sym.owner.type) : make.This(((JCTree.JCClassDecl)((Pair)this._backingSymbols.peek()).fst).type).setPos(tree.pos);
                JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), make.Select(receiver, getMethod).setPos(tree.pos), List.nil());
                methodCall = this.configMethod(tree, getMethod, methodCall);
                this.result = methodCall;
            } else {
                PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_ACCESS_WRITEONLY_PROPERTY.get(new Object[]{tree.sym.flatName()}));
            }
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement tree) {
            super.visitExec(tree);
            this.handlePropertyAssignment(tree);
        }

        private void handlePropertyAssignment(JCTree.JCExpressionStatement t) {
            Symbol.MethodSymbol setMethod;
            JCTree.JCExpression lhsSelected;
            Symbol lhsSym;
            Type lhsSelectedType;
            JCTree.JCExpression lhs;
            JCTree.JCExpression expr = t.expr;
            if (!(expr instanceof JCTree.JCAssign)) {
                return;
            }
            TreeMaker make = PropertyProcessor.this._tp.getTreeMaker();
            JCTree.JCAssign tree = (JCTree.JCAssign)expr;
            if (tree.lhs instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess;
                lhs = fieldAccess = (JCTree.JCFieldAccess)tree.lhs;
                lhsSelectedType = fieldAccess.selected.type;
                lhsSym = fieldAccess.sym;
                lhsSelected = fieldAccess.selected;
            } else if (tree.lhs instanceof JCTree.JCIdent && ((JCTree.JCIdent)tree.lhs).sym.owner instanceof Symbol.ClassSymbol) {
                JCTree.JCIdent ident = (JCTree.JCIdent)tree.lhs;
                lhs = ident;
                lhsSelectedType = ((JCTree.JCClassDecl)((Pair)this._backingSymbols.peek()).fst).type;
                lhsSym = ident.sym;
                lhsSelected = lhsSym.isStatic() ? make.Type(lhsSym.owner.type) : make.This(lhsSelectedType).setPos(t.pos);
            } else {
                return;
            }
            if (!PropertyProcessor.this.isPropertyField(lhsSym)) {
                return;
            }
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)this._methodDefs.peek();
            Context ctx = PropertyProcessor.this._javacTask.getContext();
            Symbol.MethodSymbol methodSymbol = setMethod = PropertyProcessor.this.isWritableProperty(lhsSym) ? PropertyProcessor.this.resolveSetMethod(lhsSelectedType, lhsSym, Types.instance(ctx)) : null;
            if (setMethod != null) {
                if (methodDecl != null && methodDecl.sym == setMethod) {
                    ((Set)((Pair)this._backingSymbols.peek()).snd).add((Symbol.VarSymbol)lhsSym);
                    return;
                }
                if (!this.verifyAccess(tree, lhsSym, setMethod, "Write")) {
                    return;
                }
                JCTree.JCExpression rhs = tree.rhs;
                Type parameterizedMethod = PropertyProcessor.this._tp.getTypes().memberType(lhsSelectedType, setMethod);
                while (parameterizedMethod instanceof Type.ForAll) {
                    parameterizedMethod = parameterizedMethod.asMethodType();
                }
                JCTree.JCMethodInvocation setCall = make.Apply(List.nil(), make.Select(lhsSelected, setMethod).setPos(t.pos), List.of(rhs));
                setCall = this.configMethod(lhs, setMethod, setCall);
                t.expr = setCall;
            } else if (!this._propDefs.isEmpty() && ((JCTree.JCVariableDecl)this._propDefs.peek()).sym == lhsSym) {
                ((Set)((Pair)this._backingSymbols.peek()).snd).add((Symbol.VarSymbol)lhsSym);
            } else if (methodDecl.sym.isConstructor() && lhsSelected.toString().equals("this") && lhsSym.owner == ((JCTree.JCClassDecl)((Pair)this._backingSymbols.peek()).fst).sym) {
                ((Set)((Pair)this._backingSymbols.peek()).snd).add((Symbol.VarSymbol)lhsSym);
            } else if (!Modifier.isFinal((int)lhsSym.flags_field) && ((JCTree.JCClassDecl)((Pair)this._backingSymbols.peek()).fst).sym.outermostClass() == lhsSym.outermostClass()) {
                ((Set)((Pair)this._backingSymbols.peek()).snd).add((Symbol.VarSymbol)lhsSym);
            } else {
                PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_ASSIGN_READONLY_PROPERTY.get(new Object[]{lhsSym.flatName()}));
            }
        }

        private boolean verifyAccess(JCTree.JCExpression ref, Symbol propSym, Symbol.MethodSymbol accessorMethod, String accessKind) {
            if (!PropertyProcessor.this.sameAccess(accessorMethod, propSym)) {
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)((Pair)this._backingSymbols.peek()).fst;
                Resolve resolve = Resolve.instance(PropertyProcessor.this._javacTask.getContext());
                AttrContext attrContext = new AttrContext();
                AttrContextEnv env = new AttrContextEnv((JCTree)ref, attrContext);
                env.toplevel = (JCTree.JCCompilationUnit)PropertyProcessor.this._tp.getCompilationUnit();
                env.enclClass = classDecl;
                if (!resolve.isAccessible((Env<AttrContext>)env, classDecl.type, accessorMethod)) {
                    PropertyProcessor.this.reportError(ref, PropIssueMsg.MSG_PROPERTY_NOT_ACCESSIBLE.get(new Object[]{accessKind, propSym.flatName(), PropOption.fromModifier((int)PropertyProcessor.this.getAccess(accessorMethod)).name().toLowerCase()}));
                    return false;
                }
            }
            return true;
        }

        private JCTree.JCMethodInvocation configMethod(JCTree.JCExpression tree, Symbol.MethodSymbol methodSym, JCTree.JCMethodInvocation methodTree) {
            methodTree.setPos(tree.pos);
            methodTree.type = methodSym.getReturnType();
            methodTree = ((ExtensionTransformer)PropertyProcessor.this._extensionTransformer.get()).maybeReplaceWithExtensionMethod(methodTree);
            methodTree.type = tree.type;
            return methodTree;
        }
    }

    class Enter_Finish
    extends TreeTranslator {
        private Stack<JCTree.JCClassDecl> _classes = new Stack();

        Enter_Finish() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            this._classes.push((Object)classDecl);
            try {
                super.visitClassDef(classDecl);
            }
            finally {
                this._classes.pop();
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            super.visitVarDef(tree);
            if (!PropertyProcessor.this.isPropertyField(tree.sym)) {
                return;
            }
            this.verifyPropertyMethodsAgree(tree);
            this.verifyPropertyOverride(tree);
            JCTree.JCClassDecl cls = (JCTree.JCClassDecl)this._classes.peek();
            if (PropertyProcessor.this.isInterface(cls)) {
                tree.sym.flags_field &= 0xFFFFFFFFFFFFFFEFL;
            }
        }

        private void verifyPropertyOverride(JCTree.JCVariableDecl tree) {
        }

        private void verifyPropertyMethodsAgree(JCTree.JCVariableDecl varDecl) {
            JCTree.JCAnnotation var2 = PropertyProcessor.this.getAnnotation(varDecl, var.class);
            JCTree.JCAnnotation val2 = PropertyProcessor.this.getAnnotation(varDecl, val.class);
            JCTree.JCAnnotation get2 = PropertyProcessor.this.getAnnotation(varDecl, get.class);
            JCTree.JCAnnotation set2 = PropertyProcessor.this.getAnnotation(varDecl, set.class);
            if (var2 == null && val2 == null && get2 == null && set2 == null) {
                throw new IllegalStateException();
            }
            boolean[] finalErrorHanlded = new boolean[]{false};
            this.verifyGetter(varDecl, var2, val2, get2, set2, finalErrorHanlded);
            this.verifySetter(varDecl, var2, val2, get2, set2, finalErrorHanlded[0]);
        }

        private void verifyGetter(JCTree.JCVariableDecl varDecl, JCTree.JCAnnotation var2, JCTree.JCAnnotation val2, JCTree.JCAnnotation get2, JCTree.JCAnnotation set2, boolean[] finalErrorHandled) {
            Symbol.MethodSymbol getMethod = PropertyProcessor.this.resolveGetMethod(varDecl.sym.owner.type, varDecl.sym);
            if (var2 != null || val2 != null || get2 != null) {
                int accessModifier;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this._classes.peek();
                getMethod = this.checkStatic(classDecl, varDecl, varDecl.sym, getMethod);
                if (getMethod == null) {
                    return;
                }
                List<JCTree.JCExpression> args = get2 == null ? (val2 == null ? var2.args : val2.args) : get2.args;
                boolean getAbstract = PropertyProcessor.this.isAbstract(classDecl, varDecl, args);
                boolean getFinal = PropertyProcessor.this.hasOption(args, PropOption.Final);
                PropOption getAccess = PropertyProcessor.this.getAccess(classDecl, args);
                if (getAbstract != Modifier.isAbstract((int)getMethod.flags()) && classDecl.getKind() != Tree.Kind.INTERFACE) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(new Object[]{varDecl.sym.flatName(), getMethod.flatName(), "Abstract"}));
                }
                if (getFinal && PropertyProcessor.this.isInterface(classDecl)) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_IN_INTERFACE.get(new Object[0]));
                    boolean bl = finalErrorHandled[0] = get2 == null;
                }
                if (getFinal != Modifier.isFinal((int)getMethod.flags())) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(new Object[]{varDecl.sym.flatName(), getMethod.flatName(), "Final"}));
                }
                int n = accessModifier = getAccess == null ? this.getAccess(classDecl, (int)varDecl.getModifiers().flags) : getAccess.getModifier();
                if ((getMethod.flags() & (long)accessModifier) != (long)accessModifier) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(new Object[]{varDecl.sym.flatName(), getMethod.flatName(), PropOption.fromModifier((int)accessModifier).name()}));
                }
            } else if (getMethod != null) {
                PropertyProcessor.this.reportWarning(varDecl, PropIssueMsg.MSG_GETTER_DEFINED_FOR_WRITEONLY.get(new Object[]{getMethod.flatName(), varDecl.sym.flatName()}));
            }
        }

        private void verifySetter(JCTree.JCVariableDecl varDecl, JCTree.JCAnnotation var2, JCTree.JCAnnotation val2, JCTree.JCAnnotation get2, JCTree.JCAnnotation set2, boolean finalErrorHanlded) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this._classes.peek();
            Symbol.MethodSymbol setMethod = PropertyProcessor.this.resolveSetMethod(varDecl.sym.owner.type, varDecl.sym, Types.instance(PropertyProcessor.this._javacTask.getContext()));
            if (setMethod != null && PropertyProcessor.this.isFinal(classDecl, varDecl)) {
                PropertyProcessor.this.reportWarning(varDecl, PropIssueMsg.MSG_SETTER_DEFINED_FOR_FINAL_PROPERTY.get(new Object[]{setMethod.flatName(), varDecl.name}));
            }
            if (var2 != null || set2 != null) {
                int accessModifier;
                boolean setGenerated;
                if (setMethod != null && (setMethod = this.checkStatic(classDecl, varDecl, varDecl.sym, setMethod)) == null) {
                    return;
                }
                boolean setAbstract = PropertyProcessor.this.isAbstract(classDecl, varDecl, set2 == null ? var2.args : set2.args);
                boolean setFinal = PropertyProcessor.this.hasOption(set2 == null ? var2.args : set2.args, PropOption.Final);
                PropOption setAccess = PropertyProcessor.this.getAccess(classDecl, set2 == null ? var2.args : set2.args);
                boolean bl = setGenerated = PropertyProcessor.this.getAnnotation(varDecl, propgen.class) != null;
                if (setMethod == null && !PropertyProcessor.this.isFinal(classDecl, varDecl)) {
                    throw new IllegalStateException("Setter should exist, if not user-defined, it should have been generated");
                }
                if (setMethod != null && setAbstract != Modifier.isAbstract((int)setMethod.flags()) && classDecl.getKind() != Tree.Kind.INTERFACE) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(new Object[]{varDecl.sym.flatName(), setMethod.flatName(), "Abstract"}));
                }
                if (!finalErrorHanlded && setFinal && PropertyProcessor.this.isInterface(classDecl)) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_IN_INTERFACE.get(new Object[0]));
                }
                if (setMethod != null && setFinal != Modifier.isFinal((int)setMethod.flags())) {
                    if (setGenerated) {
                        throw new IllegalStateException("generated method should match property");
                    }
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(new Object[]{varDecl.sym.flatName(), setMethod.flatName(), "Final"}));
                }
                int n = accessModifier = setAccess == null ? this.getAccess(classDecl, (int)varDecl.getModifiers().flags) : setAccess.getModifier();
                if (setMethod != null && (setMethod.flags() & (long)accessModifier) != (long)accessModifier) {
                    if (setGenerated) {
                        throw new IllegalStateException("generated method should match property");
                    }
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(new Object[]{varDecl.sym.flatName(), setMethod.flatName(), PropOption.fromModifier((int)accessModifier).name()}));
                }
            } else if (setMethod != null) {
                PropertyProcessor.this.reportWarning(varDecl, PropIssueMsg.MSG_SETTER_DEFINED_FOR_READONLY.get(new Object[]{setMethod.flatName(), varDecl.sym.flatName()}));
            }
        }

        private int getAccess(JCTree.JCClassDecl classDecl, int flags) {
            return Modifier.isPublic(flags) ? 1 : (Modifier.isProtected(flags) ? 4 : (Modifier.isPrivate(flags) ? 2 : (PropertyProcessor.this.isInterface(classDecl) ? 1 : 0)));
        }

        private Symbol.MethodSymbol checkStatic(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propDecl, Symbol field, Symbol.MethodSymbol method) {
            boolean isMethodStatic;
            if (method == null) {
                return null;
            }
            boolean isInterface = PropertyProcessor.this.isInterface(classDecl);
            boolean isPropStatic = isInterface ? ((int)propDecl.getModifiers().flags & 8) != 0 : ((int)field.flags_field & 8) != 0;
            boolean bl = isMethodStatic = ((int)method.flags_field & 8) != 0;
            if (isPropStatic != isMethodStatic) {
                if (isMethodStatic) {
                    PropertyProcessor.this.reportError(propDecl, PropIssueMsg.MSG_STATIC_MISMATCH.get(new Object[]{method.name, field.name}));
                } else {
                    PropertyProcessor.this.reportError(propDecl, PropIssueMsg.MSG_NONSTATIC_MISMATCH.get(new Object[]{method.name, field.name}));
                }
                method = null;
            }
            return method;
        }
    }

    private class Enter_Start
    extends TreeTranslator {
        private Enter_Start() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            PropertyProcessor.this._propertyStatements.push(new Pair(classDecl, new ArrayList()));
            try {
                super.visitClassDef(classDecl);
                ArrayList addedDefs = (ArrayList)((Pair)((PropertyProcessor)PropertyProcessor.this)._propertyStatements.peek()).snd;
                if (!addedDefs.isEmpty()) {
                    ArrayList<JCTree> newDefs = new ArrayList<JCTree>(classDecl.defs);
                    newDefs.addAll(addedDefs);
                    classDecl.defs = List.from(newDefs);
                }
            }
            finally {
                PropertyProcessor.this._propertyStatements.pop();
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            super.visitVarDef(tree);
            int modifiers = (int)tree.getModifiers().flags;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)((Pair)((PropertyProcessor)PropertyProcessor.this)._propertyStatements.peek()).fst;
            if (classDecl.defs.contains(tree)) {
                JCTree.JCAnnotation var2 = PropertyProcessor.this.getAnnotation(tree, var.class);
                JCTree.JCAnnotation val2 = PropertyProcessor.this.getAnnotation(tree, val.class);
                JCTree.JCAnnotation get2 = PropertyProcessor.this.getAnnotation(tree, get.class);
                JCTree.JCAnnotation set2 = PropertyProcessor.this.getAnnotation(tree, set.class);
                if (var2 == null && val2 == null && get2 == null && set2 == null) {
                    return;
                }
                if ((modifiers & 7) == 0) {
                    tree.getModifiers().flags |= 1L;
                }
                JCTree.JCMethodDecl generatedGetter = null;
                JCTree.JCMethodDecl generatedSetter = null;
                boolean shouldMakeProperty = !Modifier.isPrivate((int)tree.getModifiers().flags);
                Pair pair = (Pair)PropertyProcessor.this._propertyStatements.peek();
                if (var2 != null || val2 != null || get2 != null) {
                    List<JCTree.JCExpression> args = get2 == null ? (val2 == null ? var2.args : val2.args) : get2.args;
                    boolean getAbstract = PropertyProcessor.this.isAbstract(classDecl, tree, args) && tree.init == null;
                    boolean getFinal = PropertyProcessor.this.hasOption(args, PropOption.Final);
                    PropOption getAccess = PropertyProcessor.this.getAccess(classDecl, args);
                    if (!PropertyProcessor.this.isInterface(classDecl) && this.isWeakerAccess(getAccess, PropertyProcessor.this.getAccess(modifiers))) {
                        PropertyProcessor.this.reportError(get2 != null ? get2 : var2, PropIssueMsg.MSG_ACCESSOR_WEAKER.get(new Object[]{"get", PropOption.fromModifier((int)PropertyProcessor.this.getAccess(modifiers)).name().toLowerCase()}));
                    }
                    JCTree.JCAnnotation anno = get2 == null ? (val2 == null ? var2 : val2) : get2;
                    generatedGetter = this.makeGetter(classDecl, tree, getAbstract, getFinal, getAccess, anno);
                    if (generatedGetter == null) {
                        shouldMakeProperty = true;
                    }
                }
                if (var2 != null || set2 != null) {
                    boolean setAbstract = PropertyProcessor.this.isAbstract(classDecl, tree, set2 == null ? var2.args : set2.args);
                    boolean setFinal = PropertyProcessor.this.hasOption(set2 == null ? var2.args : set2.args, PropOption.Final);
                    PropOption setAccess = PropertyProcessor.this.getAccess(classDecl, set2 == null ? var2.args : set2.args);
                    if (setAbstract && set2 != null && var2 == null && get2 == null && tree.init != null) {
                        PropertyProcessor.this.reportError(set2, PropIssueMsg.MSG_WRITEONLY_ABSTRACT_PROPERTY_CANNOT_HAVE_INITIALIZER.get(new Object[0]));
                    }
                    if (set2 != null && PropertyProcessor.this.isFinal(classDecl, tree)) {
                        PropertyProcessor.this.reportError(set2, PropIssueMsg.MSG_SET_WITH_FINAL.get(new Object[0]));
                    } else if (!PropertyProcessor.this.isInterface(classDecl) && this.isWeakerAccess(setAccess, PropertyProcessor.this.getAccess(modifiers))) {
                        PropertyProcessor.this.reportError(set2 != null ? set2 : var2, PropIssueMsg.MSG_ACCESSOR_WEAKER.get(new Object[]{"set", PropOption.fromModifier((int)PropertyProcessor.this.getAccess(modifiers)).name().toLowerCase()}));
                    } else if (!PropertyProcessor.this.isFinal(classDecl, tree) && (generatedSetter = this.makeSetter(classDecl, tree, setAbstract, setFinal, setAccess, set2 != null ? set2 : var2)) == null) {
                        shouldMakeProperty = true;
                    }
                }
                if (shouldMakeProperty) {
                    if ((generatedGetter != null || generatedSetter != null) && PropertyProcessor.this.isInterface(classDecl) && PropertyProcessor.this.isStatic(tree)) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_INTERFACE_FIELD_BACKED_PROPERTY_NOT_SUPPORTED.get(new Object[0]));
                    } else {
                        if (generatedGetter != null) {
                            ((ArrayList)pair.snd).add(generatedGetter);
                        }
                        if (generatedSetter != null) {
                            ((ArrayList)pair.snd).add(generatedSetter);
                        }
                    }
                } else {
                    ArrayList annos = new ArrayList(tree.getModifiers().getAnnotations());
                    annos.remove(var2);
                    annos.remove(val2);
                    annos.remove(get2);
                    annos.remove(set2);
                    tree.getModifiers().annotations = List.from(annos);
                }
            }
        }

        private JCTree.JCMethodDecl makeGetter(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField, boolean propAbstract, boolean propFinal, PropOption propAccess, JCTree.JCAnnotation anno) {
            JCTree.JCMethodDecl getter;
            JCTree.JCMethodDecl existingGetter;
            Context context = PropertyProcessor.this._javacTask.getContext();
            TreeMaker make = TreeMaker.instance(context);
            long flags = propField.getModifiers().flags;
            JCTree.JCAnnotation propgenAnno = this.makePropGenAnnotation(propField);
            List<JCTree.JCAnnotation> annos = List.of(propgenAnno);
            JCTree.JCModifiers access = this.getGetterSetterModifiers(make, PropertyProcessor.this.isInterface(classDecl), propAbstract, propFinal, PropertyProcessor.this.isStatic(propField), propAccess, (int)flags, annos, propField.pos);
            Name name = Names.instance(context).fromString(PropertyProcessor.this.getGetterName(propField, true));
            JCTree.JCExpression resType = (JCTree.JCExpression)propField.vartype.clone();
            JCTree.JCBlock block = null;
            if (!propAbstract) {
                JCTree.JCReturn ret = PropertyProcessor.this.isInterface(classDecl) ? make.Return(propField.init) : make.Return(make.Ident(propField.name).setPos(propField.pos));
                block = (JCTree.JCBlock)make.Block(0L, List.of(ret)).setPos(propField.pos);
            }
            if ((existingGetter = this.findExistsingAccessor(propField, classDecl, getter = (JCTree.JCMethodDecl)make.MethodDef(access, name, resType, List.nil(), List.nil(), List.nil(), block, null).setPos(propField.pos))) != null) {
                this.addAnnotations(existingGetter, List.of(propgenAnno));
                this.addAnnotations(existingGetter, this.getAnnotations(anno, "annos"));
                return null;
            }
            if (PropertyProcessor.this.isInterface(classDecl) && PropertyProcessor.this.isStatic(propField) && !PropertyProcessor.this.isFinal(classDecl, propField)) {
                PropertyProcessor.this.reportError(propField, PropIssueMsg.MSG_MISSING_INTERFACE_STATIC_PROPERTY_ACCESSOR.get(new Object[]{classDecl.name, name + "() : " + propField.vartype.toString(), propField.name}));
            } else {
                this.addAnnotations(getter, this.getAnnotations(anno, "annos"));
            }
            return getter;
        }

        private JCTree.JCMethodDecl makeSetter(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField, boolean propAbstract, boolean propFinal, PropOption propAccess, JCTree.JCAnnotation anno) {
            Context context = PropertyProcessor.this._javacTask.getContext();
            TreeMaker make = TreeMaker.instance(context);
            long flags = propField.getModifiers().flags;
            JCTree.JCAnnotation propgenAnno = this.makePropGenAnnotation(propField);
            List<JCTree.JCAnnotation> annos = List.of(propgenAnno);
            JCTree.JCModifiers access = this.getGetterSetterModifiers(make, PropertyProcessor.this.isInterface(classDecl), propAbstract, propFinal, PropertyProcessor.this.isStatic(propField), propAccess, (int)flags, annos, propField.pos);
            Names names = Names.instance(context);
            Name name = names.fromString(PropertyProcessor.this.getSetterName(propField.name));
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)make.VarDef(make.Modifiers(0x200000010L), names.fromString("value"), (JCTree.JCExpression)propField.vartype.clone(), null).setPos(propField.pos);
            JCTree.JCExpression resType = make.Type(Symtab.instance((Context)context).voidType).setPos(propField.pos);
            JCTree.JCExpressionStatement assign = (JCTree.JCExpressionStatement)make.Exec(make.Assign(make.Ident(propField.name).setPos(propField.pos), make.Ident(names.fromString("value")).setPos(propField.pos)).setPos(propField.pos)).setPos(propField.pos);
            JCTree.JCBlock block = propAbstract ? null : (JCTree.JCBlock)make.Block(0L, List.of(assign)).setPos(propField.pos);
            JCTree.JCMethodDecl setter = (JCTree.JCMethodDecl)make.MethodDef(access, name, resType, List.nil(), List.of(param), List.nil(), block, null).setPos(propField.pos);
            JCTree.JCMethodDecl existingSetter = this.findExistsingAccessor(propField, classDecl, setter);
            if (existingSetter != null) {
                this.addAnnotations(existingSetter, List.of(propgenAnno));
                return null;
            }
            if (PropertyProcessor.this.isInterface(classDecl) && PropertyProcessor.this.isStatic(propField) && !PropertyProcessor.this.isFinal(classDecl, propField)) {
                PropertyProcessor.this.reportError(propField, PropIssueMsg.MSG_MISSING_INTERFACE_STATIC_PROPERTY_ACCESSOR.get(new Object[]{classDecl.name, name + "(" + propField.vartype.toString() + ")", propField.name}));
            } else {
                this.addAnnotations(setter, this.getAnnotations(anno, "annos"));
                this.addAnnotations(param, this.getAnnotations(anno, "param"));
            }
            return setter;
        }

        private JCTree.JCMethodDecl findExistsingAccessor(JCTree.JCVariableDecl propField, JCTree.JCClassDecl classDecl, JCTree.JCMethodDecl accessor) {
            block0: for (JCTree def : classDecl.defs) {
                if (!(def instanceof JCTree.JCMethodDecl)) continue;
                JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)def;
                if (accessor.name != tree.name || accessor.params.length() != tree.params.length()) continue;
                List<JCTree.JCVariableDecl> accessorParams = accessor.params;
                List<JCTree.JCVariableDecl> treeParams = tree.params;
                for (int i = 0; i < accessor.params.size(); ++i) {
                    JCTree.JCVariableDecl accessorParam = accessorParams.get(i);
                    JCTree.JCVariableDecl treeParam = treeParams.get(i);
                    if (!this.isSameType(tree, propField.getName(), accessorParam.vartype.toString(), treeParam.vartype.toString())) continue block0;
                }
                return tree;
            }
            return null;
        }

        private boolean isSameType(JCTree.JCMethodDecl tree, Name propName, String expected, String found) {
            if (expected.equals(found)) {
                return true;
            }
            if (this.ghettoErasure(expected).equals(this.ghettoErasure(found))) {
                PropertyProcessor.this.reportWarning(tree, PropIssueMsg.MSG_SETTER_TYPE_CONFLICT.get(new Object[]{found, propName, expected}));
                return true;
            }
            return false;
        }

        private String ghettoErasure(String type) {
            int iOpen = type.indexOf(60);
            if (iOpen < 0) {
                return type;
            }
            String erasedType = type.substring(0, iOpen);
            int iClose = type.lastIndexOf(62);
            if (iClose < 0) {
                return erasedType;
            }
            if (iClose < type.length() - 1 && !(erasedType = erasedType + type.substring(iClose + 1)).endsWith("[]")) {
                throw new IllegalStateException("Expecting an array type");
            }
            return erasedType;
        }

        private void addAnnotations(JCTree.JCMethodDecl accessor, List<JCTree.JCAnnotation> propgenAnno) {
            ArrayList<JCTree.JCAnnotation> newAnnos = new ArrayList<JCTree.JCAnnotation>(accessor.getModifiers().annotations);
            newAnnos.addAll(propgenAnno);
            accessor.getModifiers().annotations = List.from(newAnnos);
        }

        private void addAnnotations(JCTree.JCVariableDecl setterParam, List<JCTree.JCAnnotation> propgenAnno) {
            ArrayList<JCTree.JCAnnotation> newAnnos = new ArrayList<JCTree.JCAnnotation>(setterParam.getModifiers().annotations);
            newAnnos.addAll(propgenAnno);
            setterParam.getModifiers().annotations = List.from(newAnnos);
        }

        private List<JCTree.JCAnnotation> getAnnotations(JCTree.JCAnnotation anno, String target) {
            for (JCTree.JCExpression arg : anno.args) {
                if (!(arg instanceof JCTree.JCAssign)) continue;
                JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                if (!assign.lhs.toString().equals(target)) continue;
                if (assign.rhs instanceof JCTree.JCAnnotation) {
                    return List.of((JCTree.JCAnnotation)assign.rhs);
                }
                if (!(assign.rhs instanceof JCTree.JCNewArray)) continue;
                return List.from(((JCTree.JCNewArray)assign.rhs).elems);
            }
            return List.nil();
        }

        private JCTree.JCModifiers getGetterSetterModifiers(TreeMaker make, boolean isInterface, boolean propAbstract, boolean propFinal, boolean propStatic, PropOption propAccess, long flags, List<JCTree.JCAnnotation> annos, int pos) {
            long access;
            int iflags = (int)flags;
            long l = propAccess == null ? (Modifier.isPublic(iflags) ? 1L : (Modifier.isProtected(iflags) ? 4L : (Modifier.isPrivate(iflags) ? 2L : 0L))) : (access = (long)propAccess.getModifier());
            if (isInterface && !propAbstract && !propStatic) {
                access |= 0x80000000000L;
            }
            access |= (long)(propAbstract ? 1024 : 0);
            access |= (long)(propFinal ? 16 : 0);
            return (JCTree.JCModifiers)make.Modifiers(access |= (long)(propStatic ? 8 : 0), annos).setPos(pos);
        }

        private JCTree.JCAnnotation makePropGenAnnotation(JCTree.JCVariableDecl field) {
            JavacPlugin javacPlugin = JavacPlugin.instance();
            TreeMaker make = javacPlugin.getTreeMaker();
            JavacElements javacElems = javacPlugin.getJavacElements();
            Names names = Names.instance(javacPlugin.getContext());
            ArrayList<JCTree.JCAssign> args = new ArrayList<JCTree.JCAssign>();
            args.add(make.Assign(make.Ident(names.fromString("name")), make.Literal(field.name.toString())));
            args.add(make.Assign(make.Ident(names.fromString("flags")), make.Literal(field.getModifiers().flags)));
            field.getModifiers().getAnnotations().stream().filter(e -> var.class.getSimpleName().equals(e.annotationType.toString())).findFirst().ifPresent(anno -> args.add(make.Assign(make.Ident(names.fromString("var")), (JCTree.JCExpression)anno)));
            field.getModifiers().getAnnotations().stream().filter(e -> val.class.getSimpleName().equals(e.annotationType.toString())).findFirst().ifPresent(anno -> args.add(make.Assign(make.Ident(names.fromString("val")), (JCTree.JCExpression)anno)));
            field.getModifiers().getAnnotations().stream().filter(e -> get.class.getSimpleName().equals(e.annotationType.toString())).findFirst().ifPresent(anno -> args.add(make.Assign(make.Ident(names.fromString("get")), (JCTree.JCExpression)anno)));
            field.getModifiers().getAnnotations().stream().filter(e -> set.class.getSimpleName().equals(e.annotationType.toString())).findFirst().ifPresent(anno -> args.add(make.Assign(make.Ident(names.fromString("set")), (JCTree.JCExpression)anno)));
            JCTree.JCExpression propgenType = this.memberAccess(make, javacElems, propgen.class.getName());
            return make.Annotation(propgenType, List.from(args));
        }

        private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
            return this.memberAccess(make, javacElems, path.split("\\."));
        }

        private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
            JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
            for (int i = 1; i < components.length; ++i) {
                expr = make.Select(expr, node.getName(components[i]));
            }
            return expr;
        }

        private boolean isWeakerAccess(PropOption accessorOpt, int propAccess) {
            if (accessorOpt == null) {
                return false;
            }
            int accessorAccess = accessorOpt.getModifier();
            return accessorAccess == 1 && propAccess != 1 || accessorAccess == 4 && (propAccess == 0 || propAccess == 2) || accessorAccess == 0 && propAccess == 2;
        }
    }

    private class MyCompleter
    implements Symbol.Completer {
        private final Symbol.Completer _thisCompleter;

        public MyCompleter(Symbol.Completer thisCompleter) {
            this._thisCompleter = thisCompleter;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            this._thisCompleter.complete(sym);
            Names names = Names.instance(PropertyProcessor.this._javacTask.getContext());
            if (sym instanceof Symbol.ClassSymbol && sym.name != names.package_info && !this.restorePropFields((Symbol.ClassSymbol)sym, names)) {
                Annotate.instance(PropertyProcessor.this._javacTask.getContext()).normal(() -> this.restorePropFields((Symbol.ClassSymbol)sym, names));
            }
        }

        private boolean restorePropFields(Symbol.ClassSymbol classSym, Names names) {
            boolean handled = false;
            for (Symbol sym : IDynamicJdk.instance().getMembers(classSym, false)) {
                Attribute.Compound propgen2;
                if (!(sym instanceof Symbol.VarSymbol) || (propgen2 = PropertyProcessor.this.getAnnotationMirror(sym, propgen.class)) == null) continue;
                sym.flags_field = sym.flags_field & 0xFFFFFFFFFFFFFFFDL | PropertyProcessor.this.getFlags(propgen2);
                handled = true;
            }
            block1: for (Symbol sym : IDynamicJdk.instance().getMembers(classSym, false)) {
                Attribute.Compound propgenAnno;
                if (!(sym instanceof Symbol.MethodSymbol) || (propgenAnno = PropertyProcessor.this.getAnnotationMirror(sym, propgen.class)) == null) continue;
                Name fieldName = names.fromString(this.getName(propgenAnno));
                for (Symbol existing : IDynamicJdk.instance().getMembersByName(classSym, fieldName, false)) {
                    if (!(existing instanceof Symbol.VarSymbol)) continue;
                    continue block1;
                }
                Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
                Type t = ((List)meth.getParameters()).isEmpty() ? meth.getReturnType() : ((Symbol.VarSymbol)((List)meth.getParameters()).get((int)0)).type;
                Symbol.VarSymbol propField = new Symbol.VarSymbol(PropertyProcessor.this.getFlags(propgenAnno), fieldName, t, classSym);
                propField.appendAttributes(List.from(propgenAnno.values.stream().filter(e -> e.snd instanceof Attribute.Array).map(e -> (Attribute.Compound)((Attribute.Array)e.snd).values[0]).collect(Collectors.toList())));
                ReflectUtil.method((Object)ReflectUtil.field((Object)classSym, (String)"members_field").get(), (String)"enter", (Class[])new Class[]{Symbol.class}).invoke(new Object[]{propField});
                handled = true;
            }
            return handled;
        }

        private String getName(Attribute.Compound anno) {
            for (Symbol.MethodSymbol methSym : anno.getElementValues().keySet()) {
                if (!((Name)methSym.getSimpleName()).toString().equals("name")) continue;
                return (String)anno.getElementValues().get(methSym).getValue();
            }
            throw new IllegalStateException();
        }
    }
}

