/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.util.cache.FqnCache;
import manifold.rt.api.util.ManIdentifierUtil;

class Model
extends AbstractSingleFileModel {
    private FqnCache<String> _cache;

    public Model(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.buildCache(fqn, this.getFile());
    }

    public Model(IManifoldHost host, String fqn, FqnCache<String> cache) {
        super(host, fqn, Collections.emptySet());
        this._cache = cache;
    }

    public FqnCache<String> getCache() {
        return this._cache;
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        this.buildCache(this.getFqn(), file);
    }

    private void buildCache(String fqn, IFile file) {
        try (InputStream propertiesStream = file.openInputStream();){
            Properties properties = new Properties();
            properties.load(propertiesStream);
            FqnCache cache = new FqnCache(fqn, true, ManIdentifierUtil::makeIdentifier);
            for (String key : properties.stringPropertyNames()) {
                cache.add(key, (Object)properties.getProperty(key));
            }
            this._cache = cache;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

