/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcIdentifier;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcMethodCallExpression;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcReturnStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcSwitchCase;
import manifold.api.gen.SrcSwitchStatement;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.api.type.SourcePosition;
import manifold.api.util.cache.FqnCache;
import manifold.api.util.cache.FqnCacheNode;
import manifold.rt.api.util.StreamUtil;

class PropertiesCodeGen {
    private static final String FIELD_FILE_URL = "__FILE_URL_";
    private final String _fqn;
    private final String _content;
    private final FqnCache<String> _model;
    private IFile _file;

    PropertiesCodeGen(FqnCache<String> model, IFile file, String fqn) {
        this._model = model;
        this._file = file;
        this._fqn = fqn;
        this._content = this.assignContent();
    }

    SrcClass make(IModule module, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcClass = (SrcClass)new SrcClass(this._fqn, AbstractSrcClass.Kind.Class, location, module, errorHandler).imports(new Class[]{SourcePosition.class});
        this.addLocationAndPropertiesFileUrlField(srcClass, (FqnCacheNode<String>)this._model);
        return this.make(srcClass, (FqnCacheNode<String>)this._model);
    }

    private void addLocationAndPropertiesFileUrlField(SrcClass srcClass, FqnCacheNode<String> node) {
        if (this._file == null) {
            return;
        }
        srcClass.addAnnotation(this.addSourcePositionAnnotation(node));
        srcClass.addField(((SrcField)((SrcField)new SrcField((AbstractSrcClass)srcClass).name(FIELD_FILE_URL)).modifiers(24L)).type("String").initializer(this.getFile()));
    }

    private SrcClass make(SrcClass srcClass, FqnCacheNode<String> node) {
        for (FqnCacheNode childNode : node.getChildren()) {
            SrcType type = new SrcType(childNode.isLeaf() ? "String" : childNode.getName());
            SrcField propertyField = ((SrcField)((SrcField)new SrcField((AbstractSrcClass)srcClass).name(childNode.getName())).modifiers((long)(0x11 | (srcClass.getEnclosingClass() == null ? 8 : 0)))).type(type).initializer((SrcExpression)(childNode.isLeaf() ? new SrcRawExpression(new SrcType("String"), childNode.getUserData()) : new SrcRawExpression("new " + type + "()")));
            if (this._file != null) {
                propertyField.addAnnotation(this.addSourcePositionAnnotation((FqnCacheNode<String>)childNode));
            }
            srcClass.addField(propertyField);
            if (childNode.isLeaf()) continue;
            SrcClass innerSrcClass = (SrcClass)new SrcClass(childNode.getName(), (AbstractSrcClass)srcClass, AbstractSrcClass.Kind.Class).modifiers(25L);
            srcClass.addInnerClass((AbstractSrcClass)this.make(innerSrcClass, (FqnCacheNode<String>)childNode));
        }
        this.addMethods(srcClass, node);
        return srcClass;
    }

    private SrcExpression getFile() {
        try {
            return new SrcRawExpression(new SrcType("String"), (Object)this._file.toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private SrcAnnotationExpression addSourcePositionAnnotation(FqnCacheNode<String> node) {
        return new SrcAnnotationExpression(SourcePosition.class.getSimpleName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this._fqn, FIELD_FILE_URL})).name("url")).addArgument("feature", new SrcType("String"), (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)this.findOffsetOf(node)).addArgument("length", Integer.TYPE, (Object)(node.getName() == null ? 0 : node.getName().length()));
    }

    private void addMethods(SrcClass srcClass, FqnCacheNode<String> node) {
        if (!node.isLeaf()) {
            this.addGetValueByNameMethod(srcClass, node);
            String userData = (String)node.getUserData();
            if (userData != null) {
                this.addGetValueMethod(srcClass, node);
                this.addToString(srcClass);
            }
        }
    }

    private void addToString(SrcClass srcClass) {
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("toString")).modifiers(1L)).returns(new SrcType("String"))).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcReturnStatement((SrcExpression)new SrcMethodCallExpression("getValue")))));
    }

    private void addGetValueByNameMethod(SrcClass srcClass, FqnCacheNode<String> node) {
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("getValueByName")).modifiers((long)(1 | (this.isRootProperty(node) ? 8 : 0)))).returns(new SrcType("String"))).addParam(new SrcParameter("propertyName").type("String"))).body(new SrcStatementBlock().addStatement((SrcStatement)this.makeGetValueBynameSwitch(node)).addStatement((SrcStatement)new SrcReturnStatement(String.class, null))));
    }

    private boolean isRootProperty(FqnCacheNode<String> node) {
        return node.getParent() == null;
    }

    private SrcSwitchStatement makeGetValueBynameSwitch(FqnCacheNode<String> node) {
        SrcSwitchStatement stmt = new SrcSwitchStatement();
        stmt.expr((SrcExpression)new SrcIdentifier("propertyName"));
        for (FqnCacheNode childNode : node.getChildren()) {
            stmt.addCase(new SrcSwitchCase(new SrcType("String"), (Object)childNode.getName()).statement((SrcStatement)new SrcReturnStatement(String.class, childNode.getUserData())));
        }
        return stmt;
    }

    private void addGetValueMethod(SrcClass srcClass, FqnCacheNode<String> node) {
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("getValue")).modifiers((long)(1 | (this.isRootProperty(node) ? 8 : 0)))).returns(new SrcType("String"))).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcReturnStatement(String.class, node.getUserData()))));
    }

    private int findOffsetOf(FqnCacheNode<String> node) {
        String prefix;
        String fqn = node.getFqn();
        if (fqn.startsWith(prefix = this._fqn + '.')) {
            fqn = fqn.substring(prefix.length());
        }
        int offset = -1;
        int iFqn = this.findProperty(fqn, false);
        if (iFqn >= 0) {
            offset = this.useOffsetOfLastMember(fqn, iFqn);
        } else {
            iFqn = this.findProperty(fqn, true);
            if (iFqn >= 0) {
                offset = this.useOffsetOfLastMember(fqn, iFqn);
            }
        }
        if (this._file instanceof IFileFragment) {
            offset += ((IFileFragment)this._file).getOffset();
        }
        return offset;
    }

    private int useOffsetOfLastMember(String fqn, int offset) {
        if (offset < 0) {
            return offset;
        }
        int iDot = fqn.lastIndexOf(46);
        if (iDot > 0) {
            offset += iDot + 1;
        }
        return offset;
    }

    private int findProperty(String property, boolean bPartialMatch) {
        char op;
        String content = this._content;
        int index = 0;
        while (!((index = content.indexOf(property, index)) < 0 || this.isPropertyStart(content, index) && content.length() > index + property.length() && ((op = content.charAt(index + property.length())) == '=' || op == ' ' || bPartialMatch && op == '.'))) {
            if ((index += property.length()) < content.length()) continue;
            index = -1;
            break;
        }
        return index;
    }

    private boolean isPropertyStart(String content, int index) {
        if (--index < 0) {
            return true;
        }
        char c = content.charAt(index);
        if (c == '\n') {
            return true;
        }
        if (c == ' ' || c == '\t') {
            return this.isPropertyStart(content, index);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String assignContent() {
        if (this._file == null) return null;
        try (InputStream inputStream = this._file.openInputStream();){
            String string = StreamUtil.getContent((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

