/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import manifold.api.host.IManifoldHost;
import manifold.api.properties.Model;
import manifold.util.JsonUtil;
import manifold.util.cache.FqnCache;
import manifold.util.concurrent.LocklessLazyVar;

public class SystemProperties {
    private static final String FQN = "gw.lang.SystemProperties";
    private static final Set<String> _keys = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir")));

    public static Map<String, LocklessLazyVar<Model>> make(IManifoldHost host) {
        HashMap<String, LocklessLazyVar<Model>> systemProps = new HashMap<String, LocklessLazyVar<Model>>(2);
        systemProps.put(FQN, LocklessLazyVar.make(() -> {
            FqnCache cache = new FqnCache(FQN, true, JsonUtil::makeIdentifier);
            _keys.forEach(key -> cache.add(key, (Object)System.getProperty(key)));
            return new Model(host, FQN, (FqnCache<String>)cache);
        }));
        return systemProps;
    }
}

