/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcClass;
import manifold.api.host.IModule;
import manifold.api.properties.Model;
import manifold.api.properties.PropertiesCodeGen;
import manifold.api.properties.SystemProperties;
import manifold.api.type.JavaTypeManifold;
import manifold.api.util.cache.FqnCache;
import manifold.api.util.cache.FqnCacheNode;
import manifold.util.concurrent.LocklessLazyVar;

public class PropertiesTypeManifold
extends JavaTypeManifold<Model> {
    private static final Set<String> FILE_EXTENSIONS = Collections.singleton("properties");

    public void init(IModule module) {
        this.init(module, (fqn, files) -> new Model(this.getModule().getHost(), (String)fqn, (Set<IFile>)files));
    }

    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    protected Map<String, LocklessLazyVar<Model>> getPeripheralTypes() {
        return SystemProperties.make(this.getModule().getHost());
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        FqnCache<String> cache;
        Model model = (Model)this.getModel(topLevel);
        FqnCache<String> fqnCache = cache = model == null ? null : model.getCache();
        if (cache == null) {
            return false;
        }
        FqnCacheNode node = cache.getNode(relativeInner);
        return node != null && !node.isLeaf();
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, String existing, Model model, DiagnosticListener<JavaFileObject> errorHandler) {
        List files = this.findFilesForType(topLevelFqn);
        SrcClass srcClass = new PropertiesCodeGen(model.getCache(), files.isEmpty() ? null : (IFile)files.get(0), topLevelFqn).make();
        StringBuilder sb = srcClass.render(new StringBuilder(), 0);
        return sb.toString();
    }
}

