/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcIdentifier;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcMethodCallExpression;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcReturnStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcSwitchCase;
import manifold.api.gen.SrcSwitchStatement;
import manifold.api.gen.SrcType;
import manifold.api.type.SourcePosition;
import manifold.util.StreamUtil;
import manifold.util.cache.FqnCache;
import manifold.util.cache.FqnCacheNode;

public class PropertiesCodeGen {
    private static final String FIELD_FILE_URL = "__FILE_URL_";
    private final String _fqn;
    private final String _content;
    private final FqnCache<String> _model;
    private IFile _file;

    PropertiesCodeGen(FqnCache<String> model, IFile file, String fqn) {
        this._model = model;
        this._file = file;
        this._fqn = fqn;
        this._content = this.assignContent();
    }

    public SrcClass make() {
        SrcClass srcClass = new SrcClass(this._fqn, SrcClass.Kind.Class).imports(new Class[]{SourcePosition.class});
        this.addLocationAndPropertiesFileUrlField(srcClass, (FqnCacheNode<String>)this._model);
        return this.make(srcClass, (FqnCacheNode<String>)this._model);
    }

    private void addLocationAndPropertiesFileUrlField(SrcClass srcClass, FqnCacheNode<String> node) {
        if (this._file == null) {
            return;
        }
        srcClass.addAnnotation(this.addSourcePositionAnnotation(node));
        srcClass.addField(((SrcField)((SrcField)new SrcField(srcClass).name(FIELD_FILE_URL)).modifiers(24L)).type("String").initializer(this.getFile()));
    }

    public SrcClass make(SrcClass srcClass, FqnCacheNode<String> node) {
        for (FqnCacheNode childNode : node.getChildren()) {
            SrcType type = new SrcType(childNode.isLeaf() ? "String" : childNode.getName());
            SrcField propertyField = ((SrcField)((SrcField)new SrcField(srcClass).name(childNode.getName())).modifiers((long)(0x11 | (srcClass.getEnclosingClass() == null ? 8 : 0)))).type(type).initializer((SrcExpression)(childNode.isLeaf() ? new SrcRawExpression(new SrcType("String"), childNode.getUserData()) : new SrcRawExpression("new " + type + "()")));
            if (this._file != null) {
                propertyField.addAnnotation(this.addSourcePositionAnnotation((FqnCacheNode<String>)childNode));
            }
            srcClass.addField(propertyField);
            if (childNode.isLeaf()) continue;
            SrcClass innerSrcClass = (SrcClass)new SrcClass(childNode.getName(), srcClass, SrcClass.Kind.Class).modifiers(25L);
            srcClass.addInnerClass(this.make(innerSrcClass, (FqnCacheNode<String>)childNode));
        }
        this.addMethods(srcClass, node);
        return srcClass;
    }

    private SrcExpression getFile() {
        try {
            return new SrcRawExpression(new SrcType("String"), (Object)this._file.toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private SrcAnnotationExpression addSourcePositionAnnotation(FqnCacheNode<String> node) {
        return new SrcAnnotationExpression(SourcePosition.class.getSimpleName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this._fqn, FIELD_FILE_URL})).name("url")).addArgument("feature", new SrcType("String"), (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)this.findOffsetOf(node)).addArgument("length", Integer.TYPE, (Object)(node.getName() == null ? 0 : node.getName().length()));
    }

    private void addMethods(SrcClass srcClass, FqnCacheNode<String> node) {
        if (!node.isLeaf()) {
            this.addGetValueByNameMethod(srcClass, node);
            String userData = (String)node.getUserData();
            if (userData != null) {
                this.addGetValueMethod(srcClass, node);
                this.addToString(srcClass);
            }
        }
    }

    private void addToString(SrcClass srcClass) {
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod(srcClass).name("toString")).modifiers(1L)).returns(new SrcType("String"))).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcReturnStatement((SrcExpression)new SrcMethodCallExpression("getValue")))));
    }

    private void addGetValueByNameMethod(SrcClass srcClass, FqnCacheNode<String> node) {
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod(srcClass).name("getValueByName")).modifiers((long)(1 | (this.isRootProperty(node) ? 8 : 0)))).returns(new SrcType("String"))).addParam(new SrcParameter("propertyName").type("String"))).body(new SrcStatementBlock().addStatement((SrcStatement)this.makeGetValueBynameSwitch(node)).addStatement((SrcStatement)new SrcReturnStatement(String.class, null))));
    }

    private boolean isRootProperty(FqnCacheNode<String> node) {
        return node.getParent() == null;
    }

    private SrcSwitchStatement makeGetValueBynameSwitch(FqnCacheNode<String> node) {
        SrcSwitchStatement stmt = new SrcSwitchStatement();
        stmt.expr((SrcExpression)new SrcIdentifier("propertyName"));
        for (FqnCacheNode childNode : node.getChildren()) {
            stmt.addCase(new SrcSwitchCase(new SrcType("String"), (Object)childNode.getName()).statement((SrcStatement)new SrcReturnStatement(String.class, childNode.getUserData())));
        }
        return stmt;
    }

    private void addGetValueMethod(SrcClass srcClass, FqnCacheNode<String> node) {
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod(srcClass).name("getValue")).modifiers((long)(1 | (this.isRootProperty(node) ? 8 : 0)))).returns(new SrcType("String"))).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcReturnStatement(String.class, node.getUserData()))));
    }

    private int findOffsetOf(FqnCacheNode<String> node) {
        int fullFqn;
        String prefix;
        String fqn = node.getFqn();
        if (fqn.startsWith(prefix = this._fqn + '.')) {
            fqn = fqn.substring(prefix.length());
        }
        if ((fullFqn = this.findFqn(fqn, false)) >= 0) {
            return this.useOffsetOfLastMember(fqn, fullFqn);
        }
        int offset = this.findFqn(fqn, true);
        return this.useOffsetOfLastMember(fqn, offset);
    }

    private int useOffsetOfLastMember(String fqn, int offset) {
        if (offset < 0) {
            return offset;
        }
        int iDot = fqn.lastIndexOf(46);
        if (iDot > 0) {
            offset += iDot + 1;
        }
        return offset;
    }

    private int findFqn(String fqn, boolean bPartialMatch) {
        String content = this._content;
        int index = 0;
        while ((index = content.indexOf(fqn, index)) >= 0 && (index != 0 && content.charAt(index - 1) != '\n' || content.length() <= index + fqn.length() || content.charAt(index + fqn.length()) != '=' && content.charAt(index + fqn.length()) != ' ' && (!bPartialMatch || content.charAt(index + fqn.length()) != '.'))) {
            if ((index += fqn.length()) < content.length()) continue;
            index = -1;
            break;
        }
        return index;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String assignContent() {
        if (this._file == null) return null;
        try (InputStream inputStream = this._file.openInputStream();){
            String string = StreamUtil.getContent((Reader)new InputStreamReader(inputStream));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

